/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonlib.mixin.AdvancementBehaviourAccessor;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchanterItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.Disenchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.Enchanting;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiTriggers;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class DisenchanterBlockEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    public static final int DISENCHANTER_TIME = 10;
    private static final int ABSORB_AMOUNT = 100;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    int processingTicks;
    Map<Direction, LazyOptional<DisenchanterItemHandler>> itemHandlers = new IdentityHashMap<Direction, LazyOptional<DisenchanterItemHandler>>();
    AABB absorbArea;

    public DisenchanterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (Direction d : Iterate.horizontalDirections) {
            DisenchanterItemHandler disenchanterItemHandler = new DisenchanterItemHandler(this, d);
            this.itemHandlers.put(d, (LazyOptional<DisenchanterItemHandler>)LazyOptional.of(() -> disenchanterItemHandler));
        }
        this.absorbArea = new AABB(pos.m_7494_());
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        behaviours.add((TileEntityBehaviour)new DirectBeltInputBehaviour((SmartTileEntity)this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single((SmartTileEntity)this, (int)((Integer)CeiConfigs.SERVER.disenchanterTankCapacity.get())).allowExtraction().forbidInsertion();
        behaviours.add((TileEntityBehaviour)this.internalTank);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.EXPERIMENTAL.asCreateAdvancement(), CeiAdvancements.GONE_WITH_THE_FOIL.asCreateAdvancement()});
    }

    public void tick() {
        boolean onClient;
        super.tick();
        boolean bl = onClient = this.f_58857_.f_46443_ && !this.isVirtual();
        if (!onClient && this.f_58857_.m_46467_() % 10L == 0L) {
            this.absorbExperienceFromWorld();
        }
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 10;
            if (!onClient || this.processingTicks < 10) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 10)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            BlockPos nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            Direction side = this.heldItem.insertedFrom;
            ItemStack tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(this.heldItem.stack, side.m_122424_(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.m_41613_() != this.heldItem.stack.m_41613_()) {
                    if (tryExportingToBeltFunnel.m_41619_()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.m_41619_()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = (DirectBeltInputBehaviour)TileEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)(nextPosition = this.f_58858_.m_121945_(side)), (BehaviourType)DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide((BlockState)this.f_58857_.m_8055_(nextPosition), (BlockGetter)this.f_58857_, (BlockPos)nextPosition, (Direction)side.m_122424_())) {
                    ItemStack ejected = this.heldItem.stack;
                    Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    Vec3 outMotion = Vec3.m_82528_((Vec3i)side.m_122436_()).m_82490_((double)movementSpeed).m_82520_(0.0, 0.125, 0.0);
                    outPos.m_82549_(outMotion.m_82541_());
                    ItemEntity entity = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_ + 0.375, outPos.f_82481_, ejected);
                    entity.m_20256_(outMotion);
                    entity.m_32060_();
                    entity.f_19864_ = true;
                    this.f_58857_.m_7967_((Entity)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            ItemStack returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.m_41619_()) {
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.m_41613_() != this.heldItem.stack.m_41613_()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (Disenchanting.disenchantResult(this.heldItem.stack.m_41777_(), this.f_58857_) == null) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 10;
            this.sendData();
        }
    }

    protected void absorbExperienceFromWorld() {
        List experienceOrbs;
        boolean absorbedXp = false;
        List players = this.f_58857_.m_6443_(Player.class, this.absorbArea, LivingEntity::m_6084_);
        if (!players.isEmpty()) {
            AtomicInteger sum = new AtomicInteger();
            this.internalTank.allowInsertion();
            players.forEach(player -> {
                if (this.getPlayerExperience((Player)player) >= 100) {
                    sum.addAndGet(100);
                } else if (this.getPlayerExperience((Player)player) != 0) {
                    sum.addAndGet(this.getPlayerExperience((Player)player));
                }
            });
            if (sum.get() != 0) {
                FluidStack fluidStack = new FluidStack(((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).m_5613_(), sum.get());
                int inserted = this.internalTank.getPrimaryHandler().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (inserted != 0) {
                    for (Player player2 : players) {
                        int total = this.getPlayerExperience(player2);
                        if (inserted >= 100) {
                            if (total >= 100) {
                                player2.m_6756_(-100);
                                inserted -= 100;
                            } else if (total != 0) {
                                inserted -= total;
                                player2.m_6756_(-total);
                            }
                            CeiAdvancements.SPIRIT_TAKING.getTrigger().trigger((ServerPlayer)player2);
                            continue;
                        }
                        if (inserted <= 0) break;
                        if (total >= inserted) {
                            player2.m_6756_(-inserted);
                            inserted = 0;
                        } else {
                            inserted -= total;
                            player2.m_6756_(-total);
                        }
                        absorbedXp = true;
                        CeiAdvancements.SPIRIT_TAKING.getTrigger().trigger((ServerPlayer)player2);
                    }
                }
            }
            this.internalTank.forbidInsertion();
        }
        if (!(experienceOrbs = this.f_58857_.m_45976_(ExperienceOrb.class, this.absorbArea)).isEmpty()) {
            this.internalTank.allowInsertion();
            for (ExperienceOrb orb : experienceOrbs) {
                int amount = orb.f_20770_;
                FluidStack fluidStack = new FluidStack(((ExperienceFluid)((Object)CeiFluids.EXPERIENCE.get())).m_5613_(), amount);
                int inserted = this.internalTank.getPrimaryHandler().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                if (inserted == amount) {
                    absorbedXp = true;
                    orb.m_142687_(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                if (inserted == 0) break;
                absorbedXp = true;
                orb.f_20770_ -= inserted;
                break;
            }
            this.internalTank.forbidInsertion();
        }
        if (absorbedXp) {
            this.award(CeiAdvancements.EXPERIMENTAL.asCreateAdvancement());
        }
    }

    private int getPlayerExperience(Player player) {
        int level = player.f_36078_;
        if (player.f_36078_ == 0 && player.f_36080_ == 0.0f) {
            return 0;
        }
        int total = Enchanting.expPointFromLevel(level);
        int bar = (int)((float)total + player.f_36080_ * (float)player.m_36323_());
        return Math.max(bar, 1);
    }

    protected boolean continueProcessing() {
        Player player;
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        Pair<FluidStack, ItemStack> result = Disenchanting.disenchantResult(this.heldItem.stack, this.f_58857_);
        if (result == null) {
            return false;
        }
        FluidStack xp = (FluidStack)result.getFirst();
        xp.setAmount(xp.getAmount() * this.heldItem.stack.m_41613_());
        if (this.processingTicks > 5) {
            this.internalTank.allowInsertion();
            if (this.internalTank.getPrimaryHandler().fill(xp, IFluidHandler.FluidAction.SIMULATE) != xp.getAmount()) {
                this.internalTank.forbidInsertion();
                this.processingTicks = 10;
                return true;
            }
            this.internalTank.forbidInsertion();
            return true;
        }
        this.award(CeiAdvancements.EXPERIMENTAL.asCreateAdvancement());
        this.award(CeiAdvancements.GONE_WITH_THE_FOIL.asCreateAdvancement());
        AdvancementBehaviour advancementBehaviour = (AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE);
        UUID playerId = ((AdvancementBehaviourAccessor)advancementBehaviour).getPlayerId();
        if (playerId != null && (player = this.f_58857_.m_46003_(playerId)) != null) {
            CeiTriggers.DISENCHANTED.trigger(player, xp.getAmount());
        }
        ItemStack resultItem = (ItemStack)result.getSecond();
        resultItem.m_41764_(this.heldItem.stack.m_41613_());
        this.heldItem.stack = resultItem;
        this.internalTank.allowInsertion();
        this.internalTank.getPrimaryHandler().fill(xp, IFluidHandler.FluidAction.EXECUTE);
        this.internalTank.forbidInsertion();
        this.f_58857_.m_46796_(1042, this.f_58858_, 0);
        this.notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    public SmartFluidTankBehaviour getInternalTank() {
        return this.internalTank;
    }

    private ItemStack tryInsertingFromSide(TransportedItemStack transportedStack, Direction side, boolean simulate) {
        ItemStack inserted = transportedStack.stack;
        ItemStack returned = ItemStack.f_41583_;
        if (!this.getHeldItemStack().m_41619_()) {
            return inserted;
        }
        ItemStack disenchanted = Disenchanting.disenchantAndInsert(this, transportedStack.stack, simulate);
        if (!ItemStack.m_41728_((ItemStack)transportedStack.stack, (ItemStack)disenchanted)) {
            return disenchanted;
        }
        if (inserted.m_41613_() > 1 && Disenchanting.disenchantResult(inserted, this.f_58857_) != null) {
            returned = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)(inserted.m_41613_() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((ItemStack)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.m_41777_();
        transportedStack.beltPosition = side.m_122434_().m_122478_() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.m_6596_();
        this.sendData();
        return returned;
    }

    public ItemStack getHeldItemStack() {
        return this.heldItem == null ? ItemStack.f_41583_ : this.heldItem.stack;
    }

    public void setHeldItem(TransportedItemStack heldItem, Direction insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    public void invalidate() {
        super.invalidate();
        for (LazyOptional<DisenchanterItemHandler> lazyOptional : this.itemHandlers.values()) {
            lazyOptional.invalidate();
        }
    }

    public void destroy() {
        super.destroy();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            SmartFluidTank tank;
            FluidStack fluidStack;
            Fluid fluid;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack heldItemStack = this.getHeldItemStack();
            if (!heldItemStack.m_41619_()) {
                Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)heldItemStack);
            }
            if ((fluid = (fluidStack = (tank = this.getInternalTank().getPrimaryHandler()).getFluid()).getFluid()) instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)fluid;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((Vec3i)this.m_58899_()), fluidStack.getAmount());
            }
        }
    }

    public void write(CompoundTag compoundTag, boolean clientPacket) {
        compoundTag.m_128405_("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            compoundTag.m_128365_("HeldItem", (Tag)this.heldItem.serializeNBT());
        }
        super.write(compoundTag, clientPacket);
    }

    protected void read(CompoundTag compoundTag, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = compoundTag.m_128451_("ProcessingTicks");
        if (compoundTag.m_128441_("HeldItem")) {
            this.heldItem = TransportedItemStack.read((CompoundTag)compoundTag.m_128469_("HeldItem"));
        }
        super.read(compoundTag, clientPacket);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (side != null && side.m_122434_().m_122479_() && this.isItemHandlerCap(capability)) {
            return this.itemHandlers.get(side).cast();
        }
        if (side != Direction.UP && this.isFluidHandlerCap(capability)) {
            return this.internalTank.getCapability().cast();
        }
        return super.getCapability(capability, side);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }
}

