/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.foundation.utility.Pair;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingGuideItem;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantmentEntry;
import plus.dragons.createenchantmentindustry.entry.CeiItems;

public class Enchanting {
    @Nullable
    public static EnchantmentEntry getTargetEnchantment(ItemStack itemStack, boolean hyper) {
        if (itemStack.m_150930_((Item)CeiItems.ENCHANTING_GUIDE.get())) {
            EnchantmentEntry result = EnchantingGuideItem.getEnchantment(itemStack);
            if (!hyper || result == null) {
                return result;
            }
            Enchantment enchantment = (Enchantment)result.getFirst();
            int level = (Integer)result.getSecond() + 1;
            return EnchantmentEntry.of(enchantment, level);
        }
        throw new RuntimeException("TargetItem is not an enchanting guide for blaze!");
    }

    @Nullable
    public static EnchantmentEntry getValidEnchantment(ItemStack itemStack, ItemStack targetItem, boolean hyper) {
        EnchantmentEntry entry = Enchanting.getTargetEnchantment(targetItem, hyper);
        if (entry == null || !entry.valid()) {
            return null;
        }
        Enchantment enchantment = (Enchantment)entry.getFirst();
        if (!enchantment.m_6081_(itemStack)) {
            return null;
        }
        int level = (Integer)entry.getSecond();
        Map map = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        for (Map.Entry e : map.entrySet()) {
            if (!((Enchantment)e.getKey()).m_44695_(enchantment)) {
                return null;
            }
            if (e.getKey() != enchantment || (Integer)e.getValue() < (Integer)entry.getSecond() + level) continue;
            return null;
        }
        return entry;
    }

    public static void enchantItem(ItemStack itemStack, Pair<Enchantment, Integer> enchantment) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        map.put((Enchantment)enchantment.getFirst(), (Integer)enchantment.getSecond());
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack);
    }

    public static int expPointFromLevel(int level) {
        if (level > 31) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        return level > 16 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : level * level + 6 * level;
    }

    public static int expPointForNextLevel(int level) {
        if (level > 30) {
            return 9 * level - 158;
        }
        return level > 15 ? 5 * level - 38 : 2 * level + 7;
    }

    public static int rarityLevel(Enchantment.Rarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> 1;
            case Enchantment.Rarity.UNCOMMON -> 2;
            case Enchantment.Rarity.RARE -> 3;
            case Enchantment.Rarity.VERY_RARE -> 4;
        };
    }

    public static int getExperienceConsumption(Enchantment enchantment, int level) {
        int xpLevel = enchantment.m_6183_(level) + level * Enchanting.rarityLevel(enchantment.m_44699_());
        return Enchanting.expPointForNextLevel(xpLevel);
    }
}

