/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.foundation.utility.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class EnchantmentEntry
extends Pair<Enchantment, Integer> {
    public static final TagKey<Enchantment> HYPER_ENCHANTABLE;
    private static final MethodHandle getMaxLevel;

    protected EnchantmentEntry(Enchantment first, Integer second) {
        super((Object)first, (Object)second);
    }

    public static EnchantmentEntry of(Enchantment enchantment, Integer level) {
        return new EnchantmentEntry(enchantment, level);
    }

    public static EnchantmentEntry of(Enchantment enchantment, int level) {
        return new EnchantmentEntry(enchantment, level);
    }

    public boolean valid() {
        int maxLevel;
        Enchantment enchantment = (Enchantment)this.getFirst();
        int level = (Integer)this.getSecond();
        try {
            maxLevel = getMaxLevel.invoke(enchantment);
        }
        catch (Throwable throwable) {
            EnchantmentIndustry.LOGGER.warn("Failed to invoke getMaxLevel", throwable);
            maxLevel = enchantment.m_6586_();
        }
        if (enchantment.m_6586_() == 1 && level > 1) {
            return ForgeRegistries.ENCHANTMENTS.getHolder((Object)enchantment).map(holder -> holder.m_203656_(HYPER_ENCHANTABLE)).orElse(false);
        }
        return level <= maxLevel + ((Boolean)CeiConfigs.SERVER.enableHyperEnchant.get() != false ? (Integer)CeiConfigs.SERVER.maxHyperEnchantingLevelExtension.get() : 0);
    }

    static {
        Method method;
        HYPER_ENCHANTABLE = TagKey.m_203882_((ResourceKey)Registry.f_122902_, (ResourceLocation)EnchantmentIndustry.genRL("hyper_enchantable"));
        try {
            Class<?> EnchHooks = Class.forName("shadows.apotheosis.ench.asm.EnchHooks");
            method = EnchHooks.getMethod("getMaxLevel", Enchantment.class);
        }
        catch (Throwable exception) {
            EnchantmentIndustry.LOGGER.debug("Failed to load EnchHooks from Apotheosis, fall back to vanilla method...");
            method = ObfuscationReflectionHelper.findMethod(Enchantment.class, (String)"m_6586_", (Class[])new Class[0]);
        }
        try {
            method.setAccessible(true);
            getMaxLevel = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException("Failed to access Enchantment#getMaxLevel!");
        }
    }
}

