/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.shapes.pairs;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.IndexMerger;

public final class CanaryDoublePairList
implements IndexMerger {
    private final double[] merged;
    private final int[] indicesFirst;
    private final int[] indicesSecond;
    private final DoubleArrayList pairs;

    public CanaryDoublePairList(DoubleList aPoints, DoubleList bPoints, boolean flag1, boolean flag2) {
        int size = aPoints.size() + bPoints.size();
        this.merged = new double[size];
        this.indicesFirst = new int[size];
        this.indicesSecond = new int[size];
        this.pairs = DoubleArrayList.wrap((double[])this.merged);
        this.merge(CanaryDoublePairList.getArray(aPoints), CanaryDoublePairList.getArray(bPoints), aPoints.size(), bPoints.size(), flag1, flag2);
    }

    private void merge(double[] aPoints, double[] bPoints, int aSize, int bSize, boolean flag1, boolean flag2) {
        int aIdx = 0;
        int bIdx = 0;
        double prev = 0.0;
        int a1 = 0;
        int a2 = 0;
        while (true) {
            boolean bWithinBounds;
            boolean aWithinBounds = aIdx < aSize;
            boolean bl = bWithinBounds = bIdx < bSize;
            if (!aWithinBounds && !bWithinBounds) break;
            boolean flip = aWithinBounds && (!bWithinBounds || aPoints[aIdx] < bPoints[bIdx] + 1.0E-7);
            double value = flip ? aPoints[aIdx++] : bPoints[bIdx++];
            if ((aIdx == 0 || !aWithinBounds) && !flip && !flag2 || (bIdx == 0 || !bWithinBounds) && flip && !flag1) continue;
            if (a2 == 0 || prev < value - 1.0E-7) {
                this.indicesFirst[a1] = aIdx - 1;
                this.indicesSecond[a1] = bIdx - 1;
                this.merged[a2] = value;
                ++a1;
                ++a2;
                prev = value;
                continue;
            }
            if (a2 <= 0) continue;
            this.indicesFirst[a1 - 1] = aIdx - 1;
            this.indicesSecond[a1 - 1] = bIdx - 1;
        }
        if (a2 == 0) {
            this.merged[a2++] = Math.min(aPoints[aSize - 1], bPoints[bSize - 1]);
        }
        this.pairs.size(a2);
    }

    public boolean m_6200_(IndexMerger.IndexConsumer predicate) {
        int l = this.pairs.size() - 1;
        for (int i = 0; i < l; ++i) {
            if (predicate.m_82908_(this.indicesFirst[i], this.indicesSecond[i], i)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.pairs.size();
    }

    public DoubleList m_6241_() {
        return this.pairs;
    }

    private static double[] getArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            return ((DoubleArrayList)list).elements();
        }
        double[] points = new double[list.size()];
        for (int i = 0; i < points.length; ++i) {
            points[i] = list.getDouble(i);
        }
        return points;
    }
}

