/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.poi;

import com.abdelaziz.canary.common.util.Distances;
import com.abdelaziz.canary.common.world.interests.PointOfInterestSetExtended;
import com.abdelaziz.canary.common.world.interests.PointOfInterestStorageExtended;
import com.abdelaziz.canary.common.world.interests.RegionBasedStorageSectionExtended;
import com.abdelaziz.canary.common.world.interests.iterator.NearbyPointOfInterestStream;
import com.abdelaziz.canary.common.world.interests.iterator.SinglePointOfInterestTypeFilter;
import com.abdelaziz.canary.common.world.interests.iterator.SphereChunkOrderedPoiSetSpliterator;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PoiManager.class})
public abstract class PoiManagerMixin
extends SectionStorage<PoiSection>
implements PointOfInterestStorageExtended {
    public PoiManagerMixin(Path path, Function<Runnable, Codec<PoiSection>> codecFactory, Function<Runnable, PoiSection> factory, DataFixer dataFixer, DataFixTypes dataFixTypes, boolean dsync, RegistryAccess dynamicRegistryManager, LevelHeightAccessor world) {
        super(path, codecFactory, factory, dataFixer, dataFixTypes, dsync, dynamicRegistryManager, world);
    }

    @Debug
    @Overwrite
    @VisibleForDebug
    public Stream<PoiRecord> m_27117_(Predicate<Holder<PoiType>> predicate, ChunkPos pos, PoiManager.Occupancy status) {
        return ((RegionBasedStorageSectionExtended)((Object)this)).getWithinChunkColumn(pos.f_45578_, pos.f_45579_).flatMap(set -> set.m_27304_(predicate, status));
    }

    @Overwrite
    public Optional<BlockPos> m_217951_(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, PoiManager.Occupancy status, BlockPos pos, int radius, RandomSource rand) {
        ArrayList<PoiRecord> list = this.withinSphereChunkSectionSorted(typePredicate, pos, radius, status);
        int size = list.size();
        for (int i = size - 1; i >= 0; --i) {
            PoiRecord currentPOI = list.set(rand.m_188503_(i + 1), list.get(i));
            list.set(i, currentPOI);
            if (!posPredicate.test(currentPOI.m_27257_())) continue;
            return Optional.of(currentPOI.m_27257_());
        }
        return Optional.empty();
    }

    @Overwrite
    public Optional<BlockPos> m_27192_(Predicate<Holder<PoiType>> predicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        return this.m_148658_(predicate, null, pos, radius, status);
    }

    @Overwrite
    public Optional<BlockPos> m_148658_(Predicate<Holder<PoiType>> predicate, Predicate<BlockPos> posPredicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        Stream<PoiRecord> pointOfInterestStream = this.streamOutwards(pos, radius, status, true, false, predicate, posPredicate == null ? null : poi -> posPredicate.test(poi.m_27257_()));
        return pointOfInterestStream.map(PoiRecord::m_27257_).findFirst();
    }

    @Overwrite
    public long m_27121_(Predicate<Holder<PoiType>> predicate, BlockPos pos, int radius, PoiManager.Occupancy status) {
        return this.withinSphereChunkSectionSorted(predicate, pos, radius, status).size();
    }

    @Overwrite
    public Stream<PoiRecord> m_27181_(Predicate<Holder<PoiType>> predicate, BlockPos sphereOrigin, int radius, PoiManager.Occupancy status) {
        return this.withinSphereChunkSectionSortedStream(predicate, sphereOrigin, radius, status);
    }

    @Override
    public Optional<PoiRecord> findNearestForPortalLogic(BlockPos origin, int radius, Holder<PoiType> type, PoiManager.Occupancy status, Predicate<PoiRecord> afterSortPredicate, WorldBorder worldBorder) {
        boolean worldBorderIsFarAway = worldBorder == null || worldBorder.m_61941_((double)origin.m_123341_(), (double)origin.m_123343_()) > (double)(radius + 3);
        Predicate<PoiRecord> poiPredicateAfterSorting = worldBorderIsFarAway ? afterSortPredicate : poi -> worldBorder.m_61937_(poi.m_27257_()) && afterSortPredicate.test((PoiRecord)poi);
        return this.streamOutwards(origin, radius, status, true, true, new SinglePointOfInterestTypeFilter(type), poiPredicateAfterSorting).findFirst();
    }

    private Stream<PoiRecord> withinSphereChunkSectionSortedStream(Predicate<Holder<PoiType>> predicate, BlockPos origin, int radius, PoiManager.Occupancy status) {
        double radiusSq = radius * radius;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        Stream<Stream<PoiSection>> stream = StreamSupport.stream(new SphereChunkOrderedPoiSetSpliterator(radius, origin, storage), false);
        return stream.flatMap(setStream -> setStream.flatMap(set -> set.m_27304_(predicate, status).filter(point -> Distances.isWithinCircleRadius(origin, radiusSq, point.m_27257_()))));
    }

    private ArrayList<PoiRecord> withinSphereChunkSectionSorted(Predicate<Holder<PoiType>> predicate, BlockPos origin, int radius, PoiManager.Occupancy status) {
        double radiusSq = radius * radius;
        int minChunkX = origin.m_123341_() - radius - 1 >> 4;
        int minChunkZ = origin.m_123343_() - radius - 1 >> 4;
        int maxChunkX = origin.m_123341_() + radius + 1 >> 4;
        int maxChunkZ = origin.m_123343_() + radius + 1 >> 4;
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        ArrayList<PoiRecord> points = new ArrayList<PoiRecord>();
        Consumer<PoiRecord> collector = point -> {
            if (Distances.isWithinCircleRadius(origin, radiusSq, point.m_27257_())) {
                points.add((PoiRecord)point);
            }
        };
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                for (PoiSection set : storage.getInChunkColumn(x, z)) {
                    ((PointOfInterestSetExtended)set).collectMatchingPoints(predicate, status, collector);
                }
            }
        }
        return points;
    }

    private Stream<PoiRecord> streamOutwards(BlockPos origin, int radius, PoiManager.Occupancy status, boolean useSquareDistanceLimit, boolean preferNegativeY, Predicate<Holder<PoiType>> typePredicate, @Nullable Predicate<PoiRecord> afterSortingPredicate) {
        RegionBasedStorageSectionExtended storage = (RegionBasedStorageSectionExtended)((Object)this);
        return StreamSupport.stream(new NearbyPointOfInterestStream(typePredicate, status, useSquareDistanceLimit, preferNegativeY, afterSortingPredicate, origin, radius, storage), false);
    }
}

