/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.base;

import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionLighter;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.base.PoleContraptionLighter;

public abstract class PoleContraption
extends TranslatingContraption {
    protected int extensionLength;
    protected int initialExtensionProgress;
    protected Direction orientation;
    protected AABB pistonContraptionHitbox;
    protected boolean retract;

    public PoleContraption() {
    }

    public PoleContraption(Direction orientation, boolean retract) {
        this.orientation = orientation;
        this.retract = retract;
    }

    public boolean assemble(Level level, BlockPos pos) throws AssemblyException {
        if (!this.collectExtensions(level, pos, this.orientation)) {
            return false;
        }
        int count = this.blocks.size();
        if (!this.searchMovedStructure(level, this.anchor, this.retract ? this.orientation.m_122424_() : this.orientation)) {
            return false;
        }
        this.bounds = this.blocks.size() == count ? this.pistonContraptionHitbox : this.bounds.m_82367_(this.pistonContraptionHitbox);
        return true;
    }

    protected abstract boolean collectExtensions(Level var1, BlockPos var2, Direction var3) throws AssemblyException;

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return this.pistonContraptionHitbox.m_82390_(VecHelper.getCenterOf((Vec3i)pos.m_121996_((Vec3i)this.anchor)));
    }

    public void readNBT(Level level, CompoundTag tag, boolean spawnData) {
        super.readNBT(level, tag, spawnData);
        this.initialExtensionProgress = tag.m_128451_("InitialLength");
        this.extensionLength = tag.m_128451_("ExtensionLength");
        this.orientation = Direction.m_122376_((int)tag.m_128451_("Orientation"));
    }

    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_("InitialLength", this.initialExtensionProgress);
        tag.m_128405_("ExtensionLength", this.extensionLength);
        tag.m_128405_("Orientation", this.orientation.m_122411_());
        return tag;
    }

    public int extensionLength() {
        return this.extensionLength;
    }

    public int initialExtensionProgress() {
        return this.initialExtensionProgress;
    }

    public Direction orientation() {
        return this.orientation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new PoleContraptionLighter(this);
    }
}

