/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.effects;

import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonPlumeParticleData;
import rbasamoyai.createbigcannons.cannon_control.effects.CannonSmokeParticleData;
import rbasamoyai.createbigcannons.config.CBCConfigs;

public class CannonPlumeParticle
extends NoRenderParticle {
    private final Vec3 direction;
    private final float scale;
    private final PlumeSetting plumesSetting;

    CannonPlumeParticle(ClientLevel level, double x, double y, double z, Vec3 direction, float scale) {
        super(level, x, y, z);
        this.direction = direction;
        this.scale = scale;
        Minecraft mc = Minecraft.m_91087_();
        this.plumesSetting = mc.f_91066_.m_231929_().m_231551_() == ParticleStatus.ALL ? (PlumeSetting)((Object)CBCConfigs.CLIENT.showCannonPlumes.get()) : PlumeSetting.OFF;
        this.f_107225_ = 20;
        this.f_107226_ = 0.0f;
        this.m_172260_(0.0, 0.0, 0.0);
    }

    public void m_5989_() {
        if (this.plumesSetting == PlumeSetting.OFF) {
            return;
        }
        Vec3 right = this.direction.m_82537_(new Vec3(Direction.UP.m_122432_()));
        Vec3 up = this.direction.m_82537_(right);
        int count = Mth.m_14167_((float)(this.scale * (float)(this.plumesSetting == PlumeSetting.LEGACY ? 20 : 2)));
        float tScale = this.f_107224_ >= this.f_107225_ ? 0.0f : 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        for (int i = 0; i < count; ++i) {
            double dirScale = (double)this.scale * (0.9 + 0.1 * this.f_107223_.m_188500_()) * (double)tScale;
            Vec3 vel = this.direction.m_82490_(dirScale).m_82549_(right.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)this.scale * 0.5)).m_82549_(up.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)this.scale * 0.5)).m_82490_((double)0.4f);
            if (this.plumesSetting == PlumeSetting.LEGACY) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                continue;
            }
            this.f_107208_.m_7106_((ParticleOptions)new CannonSmokeParticleData(this.scale, new Vector3f(0.85f, 0.85f, 0.85f), new Vector3f(0.75f, 0.75f, 0.75f), 60), this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
        if (this.f_107224_ == 0) {
            if (this.plumesSetting == PlumeSetting.LEGACY) {
                this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
                float scale1 = this.scale / 2.0f;
                float count1 = this.scale * 50.0f;
                float speed = 0.5f;
                int i = 0;
                while ((float)i < count1) {
                    double rx = this.f_107223_.m_188583_() * (double)scale1;
                    double ry = this.f_107223_.m_188583_() * (double)scale1;
                    double rz = this.f_107223_.m_188583_() * (double)scale1;
                    double dx = this.f_107223_.m_188583_() * (double)speed;
                    double dy = this.f_107223_.m_188583_() * (double)speed;
                    double dz = this.f_107223_.m_188583_() * (double)speed;
                    this.f_107208_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, rx + this.f_107212_, ry + this.f_107213_, rz + this.f_107214_, dx, dy, dz);
                    ++i;
                }
            } else {
                float scale1 = this.scale * 0.5f;
                for (int i = 0; i < Mth.m_14167_((float)(this.scale * 2.0f)); ++i) {
                    Vec3 vel = this.direction.m_82490_((double)scale1).m_82549_(right.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale1)).m_82549_(up.m_82490_((this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * (double)scale1)).m_82490_((double)0.4f);
                    this.f_107208_.m_7106_((ParticleOptions)new CannonSmokeParticleData(this.scale * 0.25f, new Vector3f(1.0f, 0.3764706f, 0.0f), new Vector3f(0.92f, 0.92f, 0.92f), 20), this.f_107212_, this.f_107213_, this.f_107214_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                }
            }
        }
        super.m_5989_();
    }

    public static enum PlumeSetting {
        OFF,
        LEGACY,
        DEFAULT;

    }

    public static class Provider
    implements ParticleProvider<CannonPlumeParticleData> {
        public Particle createParticle(CannonPlumeParticleData data, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new CannonPlumeParticle(level, x, y, z, new Vec3(dx, dy, dz), data.scale());
        }
    }
}

