/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import rbasamoyai.createbigcannons.cannon_control.contraption.PitchOrientedContraptionEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.AnimatedAutocannon;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlockEntity;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonCartridgeItem;

public class AutocannonBreechBlockEntity
extends AutocannonBlockEntity
implements AnimatedAutocannon {
    protected static final int[] FIRE_RATES = new int[]{120, 80, 60, 48, 40, 30, 24, 20, 15, 12, 10, 8, 6, 5, 4};
    private int fireRate = 7;
    private int firingCooldown;
    private int animateTicks = 5;
    private DyeColor seat = null;
    private boolean updateInstance = true;
    private final Deque<ItemStack> inputBuffer = new LinkedList<ItemStack>();
    private ItemStack outputBuffer = ItemStack.f_41583_;

    public AutocannonBreechBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public IItemHandler createItemHandler() {
        return new BreechItemHandler(this);
    }

    public int getQueueLimit() {
        return 5;
    }

    public void tick() {
        super.tick();
        this.allTick(this.f_58857_);
    }

    @Override
    public void tickFromContraption(Level level, PitchOrientedContraptionEntity poce, BlockPos localPos) {
        super.tickFromContraption(level, poce, localPos);
        this.allTick(level);
    }

    private void allTick(Level level) {
        if (this.fireRate < 0 || this.fireRate > 15) {
            this.fireRate = 0;
        }
        if (this.firingCooldown < 0) {
            this.firingCooldown = 0;
        }
        if (this.firingCooldown > 0) {
            --this.firingCooldown;
        }
        if (this.animateTicks < 5) {
            ++this.animateTicks;
        }
        if (this.animateTicks < 0) {
            this.animateTicks = 0;
        }
    }

    public void setFireRate(int power) {
        this.fireRate = Mth.m_14045_((int)power, (int)0, (int)15);
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public int getActualFireRate() {
        if (this.fireRate < 1 || this.fireRate > 15) {
            return 0;
        }
        int cooldown = FIRE_RATES[this.fireRate - 1];
        return 1200 / cooldown;
    }

    public boolean canFire() {
        return this.getFireRate() > 0 && this.firingCooldown <= 0;
    }

    public void handleFiring() {
        if (this.fireRate > 0 && this.fireRate <= FIRE_RATES.length) {
            this.firingCooldown = FIRE_RATES[this.fireRate - 1];
            this.animateTicks = 0;
        }
    }

    public float getAnimateOffset(float partialTicks) {
        float t = ((float)this.animateTicks + partialTicks) * 1.2f;
        if (t <= 0.0f || t >= 4.8f) {
            return 0.0f;
        }
        float f = t < 1.0f ? t : (4.8f - t) / 3.8f;
        return Mth.m_14031_((float)(f * 1.5707964f));
    }

    @Override
    public void incrementAnimationTicks() {
        ++this.animateTicks;
    }

    @Override
    public int getAnimationTicks() {
        return this.animateTicks;
    }

    public void setSeatColor(DyeColor color) {
        this.seat = color;
        this.updateInstance = true;
        this.notifyUpdate();
    }

    public DyeColor getSeatColor() {
        return this.seat;
    }

    public boolean shouldUpdateInstance() {
        if (this.updateInstance) {
            this.updateInstance = false;
            return true;
        }
        return false;
    }

    public void requestModelDataUpdate() {
        super.requestModelDataUpdate();
        if (!this.f_58859_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((BlockEntity)this));
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fireRate = tag.m_128451_("FiringRate");
        this.firingCooldown = tag.m_128451_("Cooldown");
        this.animateTicks = tag.m_128451_("AnimateTicks");
        this.outputBuffer = tag.m_128441_("Output") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Output")) : ItemStack.f_41583_;
        this.seat = DyeColor.m_41057_((String)tag.m_128461_("Seat"), null);
        this.inputBuffer.clear();
        ListTag inputTag = tag.m_128437_("Input", 10);
        for (int i = 0; i < inputTag.size(); ++i) {
            this.inputBuffer.add(ItemStack.m_41712_((CompoundTag)inputTag.m_128728_(i)));
        }
        if (!clientPacket) {
            return;
        }
        this.updateInstance = tag.m_128441_("UpdateInstance");
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("FiringRate", this.fireRate);
        tag.m_128405_("Cooldown", this.firingCooldown);
        tag.m_128405_("AnimateTicks", this.animateTicks);
        if (this.outputBuffer != null && !this.outputBuffer.m_41619_()) {
            tag.m_128365_("Output", (Tag)this.outputBuffer.serializeNBT());
        }
        if (this.seat != null) {
            tag.m_128359_("Seat", this.seat.m_7912_());
        }
        if (!this.inputBuffer.isEmpty()) {
            tag.m_128365_("Input", (Tag)this.inputBuffer.stream().map(IForgeItemStack::serializeNBT).collect(Collectors.toCollection(ListTag::new)));
        }
        if (!clientPacket) {
            return;
        }
        if (this.updateInstance) {
            tag.m_128379_("UpdateInstance", true);
        }
    }

    public boolean isInputFull() {
        return this.inputBuffer.size() >= this.getQueueLimit();
    }

    public boolean isOutputFull() {
        return !this.outputBuffer.m_41619_();
    }

    public ItemStack insertOutput(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.isOutputFull()) {
            return stack;
        }
        this.outputBuffer = stack;
        return ItemStack.f_41583_;
    }

    public ItemStack extractNextInput() {
        return this.inputBuffer.isEmpty() ? ItemStack.f_41583_ : this.inputBuffer.poll();
    }

    @Override
    public List<ItemStack> getDrops() {
        List list = super.getDrops();
        for (ItemStack s : this.inputBuffer) {
            if (s.m_41619_()) continue;
            list.add(s.m_41777_());
        }
        if (!this.outputBuffer.m_41619_()) {
            list.add(this.outputBuffer.m_41777_());
        }
        return list;
    }

    public record BreechItemHandler(AutocannonBreechBlockEntity breech) implements IItemHandler
    {
        public int getSlots() {
            return 2;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return switch (slot) {
                case 0 -> this.breech.outputBuffer;
                case 1 -> {
                    if (this.breech.isInputFull()) {
                        yield this.breech.inputBuffer.peekLast();
                    }
                    yield ItemStack.f_41583_;
                }
                default -> ItemStack.f_41583_;
            };
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (slot != 1 || !this.isItemValid(slot, stack) || this.breech.isInputFull()) {
                return stack;
            }
            if (!simulate) {
                this.breech.inputBuffer.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            }
            return stack.m_41613_() == 1 ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount <= 0) {
                return ItemStack.f_41583_;
            }
            return switch (slot) {
                case 0 -> {
                    if (simulate) {
                        yield ItemHandlerHelper.copyStackWithSize((ItemStack)this.breech.outputBuffer, (int)1);
                    }
                    yield this.breech.outputBuffer.m_41620_(1);
                }
                default -> ItemStack.f_41583_;
            };
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() instanceof AutocannonCartridgeItem;
        }
    }
}

