/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.CBCBlockPartials;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBreechBlockEntity;

public class AutocannonBreechInstance
extends BlockEntityInstance<AutocannonBreechBlockEntity>
implements DynamicInstance {
    private final OrientedData ejector;
    private final OrientedData seat;
    private final Direction facing;

    public AutocannonBreechInstance(MaterialManager manager, AutocannonBreechBlockEntity blockEntity) {
        super(manager, (BlockEntity)blockEntity);
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        Quaternion q = Vector3f.f_122225_.m_122240_(this.facing.m_122434_().m_122478_() ? 180.0f : 0.0f);
        this.ejector = (OrientedData)manager.defaultCutout().material(Materials.ORIENTED).getModel(this.getPartialModelForState(), this.blockState, this.facing).createInstance();
        this.ejector.setRotation(q);
        this.seat = (OrientedData)manager.defaultCutout().material(Materials.ORIENTED).getModel(CBCBlockPartials.autocannonSeatFor(blockEntity.getSeatColor()), this.blockState, this.facing).createInstance();
        this.seat.setRotation(q);
        this.updateTransforms();
    }

    public void beginFrame() {
        this.updateTransforms();
    }

    private void updateTransforms() {
        if (((Boolean)this.blockState.m_61143_((Property)AutocannonBreechBlock.HANDLE)).booleanValue()) {
            this.ejector.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            this.seat.setPosition(this.getInstancePosition()).setColor((byte)-1, (byte)-1, (byte)-1, (byte)(((AutocannonBreechBlockEntity)this.blockEntity).getSeatColor() == null ? 0 : 255));
        } else {
            this.seat.setColor((byte)-1, (byte)-1, (byte)-1, (byte)0);
            float offset = ((AutocannonBreechBlockEntity)this.blockEntity).getAnimateOffset(AnimationTickHolder.getPartialTicks()) * 0.5f;
            Vector3f normal = this.facing.m_122424_().m_122432_();
            normal.m_122261_(offset);
            this.ejector.setPosition(this.getInstancePosition()).nudge(normal.m_122239_(), normal.m_122260_(), normal.m_122269_()).setColor((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        }
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.ejector});
        this.relight(this.pos, new FlatLit[]{this.seat});
    }

    protected void remove() {
        this.ejector.delete();
        this.seat.delete();
    }

    public boolean shouldReset() {
        return super.shouldReset() || ((AutocannonBreechBlockEntity)this.blockEntity).shouldUpdateInstance();
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonEjectorFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_EJECTOR;
        }
        return partialModel;
    }
}

