/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCBlockPartials;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonRecoilSpringBlockEntity;

public class AutocannonRecoilSpringInstance
extends BlockEntityInstance<AutocannonRecoilSpringBlockEntity>
implements DynamicInstance {
    private final ModelData spring;
    private final Map<BlockPos, OrientedData> blocks = new HashMap<BlockPos, OrientedData>();
    private final Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);

    public AutocannonRecoilSpringInstance(MaterialManager manager, AutocannonRecoilSpringBlockEntity blockEntity) {
        super(manager, (BlockEntity)blockEntity);
        this.spring = (ModelData)manager.defaultSolid().material(Materials.TRANSFORMED).getModel(this.getPartialModelForState(), this.blockState, this.facing).createInstance();
        for (Map.Entry<BlockPos, BlockState> entry : ((AutocannonRecoilSpringBlockEntity)this.blockEntity).toAnimate.entrySet()) {
            if (entry.getValue() == null) continue;
            this.blocks.put(entry.getKey(), (OrientedData)manager.defaultCutout().material(Materials.ORIENTED).getModel(entry.getValue()).createInstance());
        }
        this.updateTransforms();
    }

    public void beginFrame() {
        this.updateTransforms();
    }

    private void updateTransforms() {
        boolean flag = this.facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
        BlockPos pos = this.instancePos.m_5484_(this.facing.m_122424_(), flag ? 1 : 0);
        Vec3 pivot = Vec3.m_82528_((Vec3i)pos);
        float scale = ((AutocannonRecoilSpringBlockEntity)this.blockEntity).getAnimateOffset(AnimationTickHolder.getPartialTicks());
        float f1 = scale * 0.5f + 0.5f;
        Direction.Axis axis = this.facing.m_122434_();
        float fx = axis == Direction.Axis.X ? f1 : 1.0f;
        float fy = axis == Direction.Axis.Y ? f1 : 1.0f;
        float fz = axis == Direction.Axis.Z ? f1 : 1.0f;
        this.spring.loadIdentity().translate(pivot);
        if (flag) {
            ((ModelData)((ModelData)((ModelData)this.spring.centre()).rotate(axis.m_122478_() ? Direction.EAST : Direction.UP, (float)Math.PI)).unCentre()).translate(this.facing.m_122424_().m_122432_());
        }
        this.spring.scale(fx, fy, fz);
        Vector3f offs = this.facing.m_122432_();
        offs.m_122261_((1.0f - scale) * -0.5f);
        offs.m_122272_((float)this.instancePos.m_123341_(), (float)this.instancePos.m_123342_(), (float)this.instancePos.m_123343_());
        for (Map.Entry<BlockPos, OrientedData> entry : this.blocks.entrySet()) {
            BlockPos pos1 = entry.getKey();
            entry.getValue().setPosition(offs).nudge((float)pos1.m_123341_(), (float)pos1.m_123342_(), (float)pos1.m_123343_());
        }
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.spring});
        for (Map.Entry<BlockPos, OrientedData> entry : this.blocks.entrySet()) {
            this.relight(this.pos.m_121955_((Vec3i)entry.getKey()), new FlatLit[]{(FlatLit)entry.getValue()});
        }
    }

    protected void remove() {
        this.spring.delete();
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonSpringFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_SPRING;
        }
        return partialModel;
    }
}

