/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;

public class BigCannonBehavior
extends CannonBehavior {
    public static final BehaviourType<CannonBehavior> TYPE = new BehaviourType();
    public static final StructureTemplate.StructureBlockInfo EMPTY = new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, Blocks.f_50016_.m_49966_(), null);
    protected Optional<StructureTemplate.StructureBlockInfo> containedBlockInfo = Optional.empty();
    protected Predicate<StructureTemplate.StructureBlockInfo> predicate;

    public BigCannonBehavior(SmartTileEntity te, Predicate<StructureTemplate.StructureBlockInfo> predicate) {
        super(te);
        this.predicate = predicate;
    }

    public StructureTemplate.StructureBlockInfo block() {
        return this.containedBlockInfo.orElse(EMPTY);
    }

    public boolean tryLoadingBlock(StructureTemplate.StructureBlockInfo info) {
        if (!this.canLoadBlock(info)) {
            return false;
        }
        this.loadBlock(info);
        return true;
    }

    @Override
    public void write(CompoundTag nbt, boolean spawnPacket) {
        super.write(nbt, spawnPacket);
        if (this.containedBlockInfo.isPresent()) {
            StructureTemplate.StructureBlockInfo blockInfo = this.containedBlockInfo.get();
            if (!blockInfo.f_74676_.m_60795_()) {
                nbt.m_128356_("Pos", blockInfo.f_74675_.m_121878_());
                nbt.m_128365_("State", (Tag)NbtUtils.m_129202_((BlockState)blockInfo.f_74676_));
                if (blockInfo.f_74677_ != null) {
                    nbt.m_128365_("Data", (Tag)blockInfo.f_74677_);
                }
            }
        }
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        BlockPos pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
        BlockState state = NbtUtils.m_129241_((CompoundTag)nbt.m_128469_("State"));
        CompoundTag tag = nbt.m_128441_("Data") ? nbt.m_128469_("Data") : null;
        this.containedBlockInfo = Optional.of(new StructureTemplate.StructureBlockInfo(pos, state, tag));
    }

    public boolean canLoadBlock(StructureTemplate.StructureBlockInfo info) {
        return this.predicate.test(info);
    }

    public void loadBlock(StructureTemplate.StructureBlockInfo info) {
        this.containedBlockInfo = Optional.ofNullable(info);
    }

    public void removeBlock() {
        this.loadBlock(null);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }
}

