/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.big_cannons;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.contraptions.base.HalfShaftInstance;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.createbigcannons.CBCBlockPartials;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.ScrewBreechBlockEntity;

public class ScrewBreechInstance
extends HalfShaftInstance
implements DynamicInstance {
    private final ScrewBreechBlockEntity breech;
    private final OrientedData screwLock;
    private final Direction facing;

    public ScrewBreechInstance(MaterialManager modelManager, ScrewBreechBlockEntity tile) {
        super(modelManager, (KineticTileEntity)tile);
        this.breech = tile;
        this.facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.screwLock = (OrientedData)modelManager.defaultSolid().material(Materials.ORIENTED).getModel(this.getPartialModelForState(this.blockState)).createInstance();
        this.transformModels();
    }

    private void transformModels() {
        boolean isY;
        float renderedScrewLockOffset = this.breech.getRenderedBlockOffset(AnimationTickHolder.getPartialTicks());
        float heightOffset = renderedScrewLockOffset * 0.25f;
        float rotationOffset = renderedScrewLockOffset * (this.facing.m_122421_() == Direction.AxisDirection.POSITIVE ? 360.0f : -360.0f);
        Vector3f normal = this.facing.m_122432_();
        Vector3f height = normal.m_122281_();
        height.m_122261_(heightOffset);
        boolean bl = isY = this.facing.m_122434_() == Direction.Axis.Y;
        Quaternion q = Vector3f.f_122223_.m_122240_(isY ? (this.facing == Direction.DOWN ? 180.0f : 0.0f) : 90.0f);
        Quaternion q1 = Vector3f.f_122225_.m_122240_(isY ? 0.0f : -this.facing.m_122435_());
        Quaternion q2 = normal.m_122240_(rotationOffset);
        q1.m_80148_(q);
        q2.m_80148_(q1);
        this.screwLock.setPosition(this.getInstancePosition()).nudge(height.m_122239_(), height.m_122260_(), height.m_122269_()).setRotation(q2);
    }

    public void beginFrame() {
        this.transformModels();
    }

    public void remove() {
        super.remove();
        this.screwLock.delete();
    }

    public void updateLight() {
        super.updateLight();
        this.screwLock.updateLight((BlockAndTintGetter)this.world, this.instancePos);
    }

    private PartialModel getPartialModelForState(BlockState state) {
        return state.m_60734_() instanceof BigCannonBlock ? CBCBlockPartials.screwLockFor(((BigCannonBlock)state.m_60734_()).getCannonMaterial()) : CBCBlockPartials.STEEL_SCREW_LOCK;
    }
}

