/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.config;

import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.ConfigBase;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.config.CBCCfgClient;
import rbasamoyai.createbigcannons.config.CBCCfgCommon;
import rbasamoyai.createbigcannons.config.CBCCfgServer;
import rbasamoyai.createbigcannons.config.CBCConfigBase;

@Mod.EventBusSubscriber(modid="createbigcannons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CBCConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    public static CBCCfgClient CLIENT;
    public static CBCCfgCommon COMMON;
    public static CBCCfgServer SERVER;

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CBCConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CBCConfigBase config = (CBCConfigBase)((Object)((Object)factory.get()));
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CBCConfigBase config = (CBCConfigBase)((Object)specPair.getLeft());
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)((Object)config);
    }

    public static void registerConfigs(ModLoadingContext context) {
        CLIENT = CBCConfigs.register(CBCCfgClient::new, ModConfig.Type.CLIENT);
        COMMON = CBCConfigs.register(CBCCfgCommon::new, ModConfig.Type.COMMON);
        SERVER = CBCConfigs.register(CBCCfgServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)"createbigcannons", (BlockStressValues.IStressValueProvider)CBCConfigs.SERVER.kinetics.stress);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

