/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.builtup;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.CBCContraptionTypes;
import rbasamoyai.createbigcannons.base.PoleContraption;
import rbasamoyai.createbigcannons.cannons.CannonBehavior;
import rbasamoyai.createbigcannons.cannons.ICannonBlockEntity;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonMaterial;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlock;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderBlockEntity;
import rbasamoyai.createbigcannons.crafting.builtup.CannonBuilderHeadBlock;
import rbasamoyai.createbigcannons.crafting.builtup.LayeredBigCannonBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;

public class CannonBuildingContraption
extends PoleContraption {
    protected boolean isActivated = false;
    protected BigCannonMaterial material = null;
    private static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public CannonBuildingContraption() {
    }

    public CannonBuildingContraption(Direction orientation, boolean retract) {
        super(orientation, retract);
    }

    @Override
    protected boolean collectExtensions(Level level, BlockPos pos, Direction direction) throws AssemblyException {
        if (!CBCBlocks.CANNON_BUILDER.has(level.m_8055_(pos))) {
            return false;
        }
        ArrayList<StructureTemplate.StructureBlockInfo> poles = new ArrayList<StructureTemplate.StructureBlockInfo>();
        BlockPos start = pos;
        BlockState nextBlock = level.m_8055_(start.m_121945_(direction));
        int extensionsInFront = 0;
        Direction.Axis blockAxis = direction.m_122434_();
        PistonExtensionPoleBlock.PlacementHelper matcher = PistonExtensionPoleBlock.PlacementHelper.get();
        if (level.m_8055_(pos).m_61143_(CannonBuilderBlock.STATE) == CannonBuilderBlock.BuilderState.EXTENDED) {
            while (matcher.matchesAxis(nextBlock, blockAxis) || CannonBuildingContraption.isBuilderHead(nextBlock) && nextBlock.m_61143_((Property)FACING) == direction) {
                start = start.m_121945_(direction);
                poles.add(new StructureTemplate.StructureBlockInfo(start, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
                ++extensionsInFront;
                if (CannonBuildingContraption.isBuilderHead(nextBlock)) {
                    this.isActivated = (Boolean)nextBlock.m_61143_((Property)CannonBuilderHeadBlock.ATTACHED);
                    break;
                }
                nextBlock = level.m_8055_(start.m_121945_(direction));
                if (extensionsInFront <= CannonBuilderBlock.maxAllowedBuilderLength()) continue;
                throw AssemblyException.tooManyPistonPoles();
            }
        }
        if (extensionsInFront == 0) {
            this.isActivated = level.m_8055_(pos).m_61143_(CannonBuilderBlock.STATE) == CannonBuilderBlock.BuilderState.ACTIVATED;
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)((BlockState)CBCBlocks.CANNON_BUILDER_HEAD.getDefaultState().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)CannonBuilderHeadBlock.ATTACHED, (Comparable)Boolean.valueOf(this.isActivated)), null));
        } else {
            poles.add(new StructureTemplate.StructureBlockInfo(pos, (BlockState)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().m_61124_((Property)FACING, (Comparable)direction), null));
        }
        BlockPos end = pos;
        int extensionsInBack = 0;
        Direction opposite = direction.m_122424_();
        nextBlock = level.m_8055_(end.m_121945_(opposite));
        while (matcher.matchesAxis(nextBlock, blockAxis)) {
            end = end.m_121945_(opposite);
            poles.add(new StructureTemplate.StructureBlockInfo(end, (BlockState)nextBlock.m_61124_((Property)FACING, (Comparable)direction), null));
            nextBlock = level.m_8055_(end.m_121945_(opposite));
            if (extensionsInFront + ++extensionsInBack <= CannonBuilderBlock.maxAllowedBuilderLength()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.extensionLength = extensionsInFront + extensionsInBack;
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.anchor = pos.m_5484_(direction, this.initialExtensionProgress + 1);
        this.initialExtensionProgress = extensionsInFront;
        this.pistonContraptionHitbox = new AABB(BlockPos.f_121853_, BlockPos.f_121853_.m_5484_(direction, -this.extensionLength - 1)).m_82363_(1.0, 1.0, 1.0);
        this.bounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (StructureTemplate.StructureBlockInfo pole : poles) {
            BlockPos relPos = pole.f_74675_.m_5484_(direction, -extensionsInFront);
            BlockPos localPos = relPos.m_121996_((Vec3i)this.anchor);
            this.getBlocks().put(localPos, new StructureTemplate.StructureBlockInfo(localPos, pole.f_74676_, null));
        }
        return true;
    }

    protected boolean addToInitialFrontier(Level level, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        frontier.clear();
        if (!this.isActivated) {
            return true;
        }
        boolean retracting = forcedDirection != this.orientation;
        HashSet<CannonCastShape> connectedShapes = new HashSet<CannonCastShape>();
        CannonCastShape fullShape = null;
        HashMap<BlockPos, Pair> preAddedBlocks = new HashMap<BlockPos, Pair>();
        Direction opposite = this.orientation.m_122424_();
        boolean firstBlock = true;
        for (int offset = 0; offset <= (Integer)CBCConfigs.SERVER.crafting.maxCannonBuilderRange.get(); ++offset) {
            BlockPos currentPos = pos.m_5484_(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && level.m_151570_(currentPos)) {
                preAddedBlocks.forEach(this::addBlock);
                return this.material != null && !firstBlock;
            }
            if (!level.m_46749_(currentPos)) {
                throw AssemblyException.unloadedChunk((BlockPos)currentPos);
            }
            BlockState state = level.m_8055_(currentPos);
            if (this.isValidCannonBlock(level, state, currentPos) && CannonBuildingContraption.matchesCannonAxis(state, this.orientation.m_122434_()) && this.matchesCurrentMaterial(level, state, currentPos)) {
                BlockPos backPos;
                BlockEntity blockEntity;
                BlockEntity blockEntity2;
                BigCannonBlock cBlock = (BigCannonBlock)state.m_60734_();
                if (this.material == null) {
                    this.material = cBlock.getCannonMaterialInLevel((LevelAccessor)level, state, currentPos);
                }
                if ((blockEntity2 = level.m_7702_(currentPos)) instanceof LayeredBigCannonBlockEntity) {
                    LayeredBigCannonBlockEntity split;
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity2;
                    if (fullShape == null && connectedShapes.isEmpty()) {
                        if (firstBlock) {
                            CannonCastShape topShape = layered.getTopCannonShape();
                            connectedShapes.add(topShape);
                            firstBlock = false;
                        } else {
                            if (!preAddedBlocks.isEmpty()) break;
                            return false;
                        }
                    }
                    LayeredBigCannonBlockEntity layeredBigCannonBlockEntity = fullShape == null ? layered.getSplitBlockEntity(connectedShapes, offset == 0 ? null : opposite) : (split = layered.getSplitBlockEntity(fullShape, opposite));
                    if (split.isEmpty()) break;
                    if (layered.getLayers().size() > 1 && offset == 0 && forcedDirection == this.orientation) {
                        return false;
                    }
                    BlockState simpleState = split.getSimplifiedBlock().m_49966_();
                    if (!simpleState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        return false;
                    }
                    simpleState = (BlockState)simpleState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)cBlock.getFacing(state));
                    CompoundTag tag = this.getBlockEntityTag((BlockEntity)split);
                    preAddedBlocks.put(currentPos, Pair.of((Object)new StructureTemplate.StructureBlockInfo(currentPos, simpleState, tag), (Object)split));
                    connectedShapes.addAll(split.getLayers().keySet());
                    Collection<CannonCastShape> connectedShapes1 = split.getConnectedTo(this.orientation);
                    connectedShapes.removeIf(s -> !connectedShapes1.contains(s));
                    fullShape = null;
                    continue;
                }
                CannonCastShape shape = cBlock.getShapeInLevel((LevelAccessor)level, state, currentPos);
                if (fullShape == null && !CannonBuildingContraption.isConnected(connectedShapes, shape)) {
                    if (firstBlock) {
                        connectedShapes.add(shape);
                        firstBlock = false;
                    } else {
                        if (!preAddedBlocks.isEmpty()) break;
                        return false;
                    }
                }
                for (int back = 1; back < offset && (blockEntity = level.m_7702_(backPos = currentPos.m_5484_(opposite, back))) instanceof LayeredBigCannonBlockEntity; ++back) {
                    LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity;
                    Pair backPair = (Pair)preAddedBlocks.get(backPos);
                    Object object = backPair.getRight();
                    if (!(object instanceof LayeredBigCannonBlockEntity)) break;
                    LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)object;
                    Set backConnected = layered.getConnectedTo(this.orientation).stream().filter(s -> s.diameter() < shape.diameter()).collect(Collectors.toCollection(HashSet::new));
                    if (backConnected.isEmpty()) break;
                    Set allSet = layered.getLayers().keySet().stream().filter(s -> s.diameter() < shape.diameter()).collect(Collectors.toCollection(HashSet::new));
                    allSet.removeAll(backConnected);
                    if (!allSet.isEmpty() && forcedDirection != this.orientation) {
                        return false;
                    }
                    for (CannonCastShape shape1 : backConnected) {
                        if (shape1.diameter() >= shape.diameter()) continue;
                        layered1.setLayer(shape1, layered.getLayer(shape1));
                        for (Direction dir : Iterate.directions) {
                            layered1.setLayerConnectedTo(dir, shape1, layered.isLayerConnectedTo(dir, shape1));
                        }
                    }
                    BlockState simpleState = layered1.getSimplifiedBlock().m_49966_();
                    if (!simpleState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                        return false;
                    }
                    simpleState = (BlockState)simpleState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)cBlock.getFacing(state));
                    CompoundTag tag = this.getBlockEntityTag((BlockEntity)layered1);
                    preAddedBlocks.put(backPos, Pair.of((Object)new StructureTemplate.StructureBlockInfo(backPos, simpleState, tag), (Object)layered1));
                }
                BlockEntity be = level.m_7702_(currentPos);
                preAddedBlocks.put(currentPos, Pair.of((Object)new StructureTemplate.StructureBlockInfo(currentPos, state, this.getBlockEntityTag(be)), (Object)be));
                fullShape = CannonBuildingContraption.isConnectedTo(level, shape, cBlock, state, currentPos, this.orientation) ? shape : null;
                connectedShapes.clear();
                continue;
            }
            if (forcedDirection != this.orientation || state.m_60767_().m_76336_() && state.m_60812_((BlockGetter)level, currentPos).m_83281_()) break;
            return false;
        }
        if (this.material != null && !firstBlock) {
            preAddedBlocks.forEach(this::addBlock);
        } else {
            this.isActivated = false;
        }
        return true;
    }

    protected CompoundTag getBlockEntityTag(BlockEntity be) {
        if (be == null) {
            return null;
        }
        CompoundTag tag = be.m_187480_();
        tag.m_128473_("x");
        tag.m_128473_("y");
        tag.m_128473_("z");
        return tag;
    }

    private boolean isValidCannonBlock(Level level, BlockState state, BlockPos currentPos) {
        return state.m_60734_() instanceof BigCannonBlock && level.m_7702_(currentPos) instanceof ICannonBlockEntity;
    }

    private static boolean matchesCannonAxis(BlockState state, Direction.Axis axis) {
        return ((BigCannonBlock)state.m_60734_()).getFacing(state).m_122434_() == axis;
    }

    private boolean matchesCurrentMaterial(Level level, BlockState state, BlockPos pos) {
        return this.material == null || ((BigCannonBlock)state.m_60734_()).getCannonMaterialInLevel((LevelAccessor)level, state, pos) == this.material;
    }

    private static boolean isConnectedTo(Level level, CannonCastShape shape, BigCannonBlock cBlock, BlockState state, BlockPos pos, Direction dir) {
        ICannonBlockEntity cbe;
        BlockEntity blockEntity;
        if (cBlock.getFacing(state).m_122434_() != dir.m_122434_() || cBlock.getShapeInLevel((LevelAccessor)level, state, pos) != shape || !((blockEntity = level.m_7702_(pos)) instanceof ICannonBlockEntity) || !((CannonBehavior)((Object)(cbe = (ICannonBlockEntity)blockEntity).cannonBehavior())).isConnectedTo(dir)) {
            return false;
        }
        BlockEntity be = level.m_7702_(pos.m_121945_(dir));
        if (be instanceof LayeredBigCannonBlockEntity) {
            LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)be;
            return layered.isLayerConnectedTo(dir.m_122424_(), shape);
        }
        if (be instanceof ICannonBlockEntity) {
            ICannonBlockEntity cbe1 = (ICannonBlockEntity)be;
            return ((CannonBehavior)((Object)cbe1.cannonBehavior())).isConnectedTo(dir.m_122424_());
        }
        return false;
    }

    private static boolean isConnected(Collection<CannonCastShape> connected, CannonCastShape full) {
        return connected.stream().anyMatch(s -> s.diameter() <= full.diameter());
    }

    protected void addBlock(BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
        BlockPos offset = pos.m_5484_(this.orientation, -this.initialExtensionProgress);
        super.addBlock(offset, pair);
        BlockEntity te = (BlockEntity)pair.getRight();
        if (te != null) {
            this.presentTileEntities.put(offset.m_121996_((Vec3i)this.anchor), te);
        }
    }

    protected boolean customBlockPlacement(LevelAccessor level, BlockPos pos, BlockState state) {
        CannonBuilderBlockEntity builder;
        BlockState builderState;
        BlockPos levelPos;
        block10: {
            block9: {
                levelPos = this.anchor.m_5484_(this.orientation, -1);
                builderState = level.m_8055_(levelPos);
                BlockEntity blockEntity = level.m_7702_(levelPos);
                if (!(blockEntity instanceof CannonBuilderBlockEntity)) break block9;
                builder = (CannonBuilderBlockEntity)blockEntity;
                if (!blockEntity.m_58901_()) break block10;
            }
            return true;
        }
        if (pos.equals((Object)levelPos)) {
            if (CBCBlocks.CANNON_BUILDER_HEAD.has(state) && CBCBlocks.CANNON_BUILDER.has(builderState)) {
                CannonBuilderBlock.BuilderState bState = (Boolean)state.m_61143_((Property)CannonBuilderHeadBlock.ATTACHED) != false ? CannonBuilderBlock.BuilderState.ACTIVATED : CannonBuilderBlock.BuilderState.UNACTIVATED;
                level.m_7731_(levelPos, (BlockState)builderState.m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)bState)), 19);
            }
            return true;
        }
        if (builder.movedContraption != null) {
            BlockPos entityAnchor = new BlockPos(builder.movedContraption.getAnchorVec().m_82520_(0.5, 0.5, 0.5));
            BlockPos blockPos = pos.m_121996_((Vec3i)entityAnchor);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.getBlocks().get(blockPos);
            BlockEntity blockEntity1 = level.m_7702_(pos);
            if (blockEntity1 instanceof LayeredBigCannonBlockEntity) {
                LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity1;
                if (blockInfo.f_74677_ == null || !blockInfo.f_74677_.m_128441_("id")) {
                    return true;
                }
                BlockEntity infoBE = BlockEntity.m_155241_((BlockPos)blockPos, (BlockState)builderState, (CompoundTag)blockInfo.f_74677_);
                if (!(infoBE instanceof LayeredBigCannonBlockEntity)) {
                    return true;
                }
                LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)infoBE;
                layered.addLayersOfOther(layered1);
                layered.updateBlockstate();
                layered.sendData();
                return true;
            }
        }
        return false;
    }

    protected boolean customBlockRemoval(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos levelPos = this.anchor.m_5484_(this.orientation, -1);
        BlockState builderState = level.m_8055_(levelPos);
        BlockEntity blockEntity = level.m_7702_(levelPos);
        if (!(blockEntity instanceof CannonBuilderBlockEntity)) {
            return true;
        }
        CannonBuilderBlockEntity builder = (CannonBuilderBlockEntity)blockEntity;
        if (pos.equals((Object)levelPos) && CBCBlocks.CANNON_BUILDER.has(builderState)) {
            level.m_7731_(levelPos, (BlockState)builderState.m_61124_(CannonBuilderBlock.STATE, (Comparable)((Object)CannonBuilderBlock.BuilderState.MOVING)), 82);
            return true;
        }
        BlockPos blockPos = pos.m_5484_(this.orientation, -this.initialExtensionProgress).m_121996_((Vec3i)this.anchor);
        StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.getBlocks().get(blockPos);
        BlockEntity blockEntity1 = level.m_7702_(pos);
        if (blockInfo != null && blockEntity1 instanceof LayeredBigCannonBlockEntity) {
            LayeredBigCannonBlockEntity layered = (LayeredBigCannonBlockEntity)blockEntity1;
            if (blockInfo.f_74677_ == null || !blockInfo.f_74677_.m_128441_("id")) {
                return true;
            }
            BlockEntity infoBE = BlockEntity.m_155241_((BlockPos)blockPos, (BlockState)builderState, (CompoundTag)blockInfo.f_74677_);
            if (!(infoBE instanceof LayeredBigCannonBlockEntity)) {
                return true;
            }
            LayeredBigCannonBlockEntity layered1 = (LayeredBigCannonBlockEntity)infoBE;
            layered.removeLayersOfOther(layered1);
            layered.updateBlockstate();
            layered.sendData();
            return true;
        }
        return false;
    }

    public Set<BlockPos> getColliders(Level level, Direction movementDirection) {
        if (!this.isActivated) {
            return super.getColliders(level, movementDirection);
        }
        if (this.getBlocks() == null) {
            return Collections.emptySet();
        }
        if (this.cachedColliders == null || this.cachedColliderDirection != movementDirection) {
            this.cachedColliders = new HashSet();
            this.cachedColliderDirection = movementDirection;
            for (StructureTemplate.StructureBlockInfo blockInfo : this.getBlocks().values()) {
                BlockPos offsetPos = blockInfo.f_74675_.m_121945_(movementDirection);
                if (blockInfo.f_74676_.m_60812_((BlockGetter)level, offsetPos).m_83281_() || CBCBlocks.CANNON_BUILDER_HEAD.has(blockInfo.f_74676_) && movementDirection != this.orientation) continue;
                if (this.getBlocks().containsKey(offsetPos)) {
                    StructureTemplate.StructureBlockInfo offsetInfo = (StructureTemplate.StructureBlockInfo)this.getBlocks().get(offsetPos);
                    if (!offsetInfo.f_74676_.m_60812_((BlockGetter)level, offsetPos).m_83281_() && (AllBlocks.PISTON_EXTENSION_POLE.has(blockInfo.f_74676_) || CBCBlocks.CANNON_BUILDER_HEAD.has(offsetInfo.f_74676_))) continue;
                }
                this.cachedColliders.add(blockInfo.f_74675_);
            }
        }
        return this.cachedColliders;
    }

    private static boolean isBuilderHead(BlockState state) {
        return CBCBlocks.CANNON_BUILDER_HEAD.has(state);
    }

    @Override
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128379_("Activated", this.isActivated);
        if (this.material != null) {
            tag.m_128359_("Material", this.material.name().toString());
        }
        return tag;
    }

    @Override
    public void readNBT(Level level, CompoundTag tag, boolean spawnData) {
        super.readNBT(level, tag, spawnData);
        this.isActivated = tag.m_128471_("Activated");
        this.material = BigCannonMaterial.fromName(new ResourceLocation(tag.m_128461_("Material")));
        if (this.material == null) {
            this.material = BigCannonMaterial.STEEL;
        }
    }

    protected ContraptionType getType() {
        return CBCContraptionTypes.CANNON_BUILDER;
    }
}

