/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import rbasamoyai.createbigcannons.CBCBlockPartials;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastBlockEntity;
import rbasamoyai.createbigcannons.crafting.casting.CannonCastShape;

public class CannonCastBlockEntityRenderer
extends SafeTileEntityRenderer<CannonCastBlockEntity> {
    private final BlockRenderDispatcher dispatcher;

    public CannonCastBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.m_173584_();
    }

    protected void renderSafe(CannonCastBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!te.canRenderCastModel()) {
            return;
        }
        BlockState state = te.m_58900_();
        ms.m_85836_();
        CannonCastShape shape = te.getRenderedSize();
        if (shape != null) {
            CachedBufferer.partial((PartialModel)CBCBlockPartials.cannonCastFor(shape), (BlockState)state).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        if (te.isController()) {
            LerpedFloat castProgressLerped;
            LerpedFloat levelLerped = te.getFluidLevel();
            if (levelLerped != null && shape != null) {
                float level = levelLerped.getValue(partialTicks);
                FluidStack fstack = te.fluid.getFluid();
                boolean flag = shape.isLarge();
                float boxWidth = flag ? 2.875f : 0.875f;
                float height = ((float)te.height - 0.125f) * level;
                if (height > 0.0625f && !fstack.isEmpty()) {
                    ms.m_85836_();
                    float f = flag ? -0.9375f : 0.0625f;
                    ms.m_85837_((double)f, 0.0625, (double)f);
                    FluidRenderer.renderFluidBox((FluidStack)fstack, (float)0.0f, (float)0.0f, (float)0.0f, (float)boxWidth, (float)height, (float)boxWidth, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
                    ms.m_85849_();
                }
            }
            if ((castProgressLerped = te.getCastingLevel()) != null) {
                float alpha = castProgressLerped.getValue(partialTicks);
                for (int l = 0; l < te.resultPreview.size(); ++l) {
                    BlockState state1 = te.resultPreview.get(l);
                    VertexConsumer vCons = buffer.m_6299_(Sheets.m_110791_());
                    BakedModel model = this.dispatcher.m_110910_(state1);
                    RandomSource rand = RandomSource.m_216327_();
                    ms.m_85836_();
                    ms.m_85837_(0.0, (double)l, 0.0);
                    for (Direction dir : Direction.values()) {
                        rand.m_188584_(42L);
                        CannonCastBlockEntityRenderer.renderQuadList(ms.m_85850_(), vCons, 1.0f, 1.0f, 1.0f, alpha, model.getQuads(state, dir, rand, ModelUtil.VIRTUAL_DATA, null), light, overlay);
                    }
                    rand.m_188584_(42L);
                    CannonCastBlockEntityRenderer.renderQuadList(ms.m_85850_(), vCons, 1.0f, 1.0f, 1.0f, alpha, model.getQuads(state, null, rand, ModelUtil.VIRTUAL_DATA, null), light, overlay);
                    ms.m_85849_();
                }
            }
        }
        ms.m_85849_();
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexConsumer consumer, float red, float green, float blue, float alpha, List<BakedQuad> quads, int packedLight, int packedOverlay) {
        for (BakedQuad quad : quads) {
            float f2;
            float f1;
            float f;
            if (quad.m_111304_()) {
                f = Mth.m_14036_((float)red, (float)0.0f, (float)1.0f);
                f1 = Mth.m_14036_((float)green, (float)0.0f, (float)1.0f);
                f2 = Mth.m_14036_((float)blue, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            consumer.putBulkData(pose, quad, f, f1, f2, alpha, packedLight, packedOverlay, true);
        }
    }
}

