/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.simibubi.create.content.contraptions.base.DirectionalAxisKineticBlock;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.base.CBCRegistries;

public class CannonCastShape {
    public static final DeferredRegister<CannonCastShape> CANNON_CAST_SHAPES = DeferredRegister.create(CBCRegistries.CANNON_CAST_SHAPES_KEY, (String)"createbigcannons");
    private static final int INGOT_SIZE_MB = 90;
    public static final RegistryObject<CannonCastShape> VERY_SMALL = CANNON_CAST_SHAPES.register("very_small", () -> new CannonCastShape(630, 12, (NonNullSupplier<? extends Block>)CBCBlocks.VERY_SMALL_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> SMALL = CANNON_CAST_SHAPES.register("small", () -> new CannonCastShape(810, 14, (NonNullSupplier<? extends Block>)CBCBlocks.SMALL_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> MEDIUM = CANNON_CAST_SHAPES.register("medium", () -> new CannonCastShape(1080, 16, (NonNullSupplier<? extends Block>)CBCBlocks.MEDIUM_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> LARGE = CANNON_CAST_SHAPES.register("large", () -> new CannonCastShape(1260, 18, (NonNullSupplier<? extends Block>)CBCBlocks.LARGE_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> VERY_LARGE = CANNON_CAST_SHAPES.register("very_large", () -> new CannonCastShape(1800, 20, (NonNullSupplier<? extends Block>)CBCBlocks.VERY_LARGE_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> CANNON_END = CANNON_CAST_SHAPES.register("cannon_end", () -> new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.CANNON_END_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> SLIDING_BREECH = CANNON_CAST_SHAPES.register("sliding_breech", () -> new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.SLIDING_BREECH_CAST_MOULD, PropertySetter.of(DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, false)));
    public static final RegistryObject<CannonCastShape> SCREW_BREECH = CANNON_CAST_SHAPES.register("screw_breech", () -> new CannonCastShape(810, 16, (NonNullSupplier<? extends Block>)CBCBlocks.SCREW_BREECH_CAST_MOULD, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> AUTOCANNON_BARREL = CANNON_CAST_SHAPES.register("autocannon_barrel", () -> new CannonCastShape(270, 4, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_BARREL_CAST_MOULD, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    public static final RegistryObject<CannonCastShape> AUTOCANNON_BARREL_FLANGED = CANNON_CAST_SHAPES.register("autocannon_barrel_flanged", () -> new CannonCastShape(270, 4, (NonNullSupplier<? extends Block>)((NonNullSupplier)() -> Blocks.f_50016_), false, new PropertySetter[0]));
    public static final RegistryObject<CannonCastShape> AUTOCANNON_BREECH = CANNON_CAST_SHAPES.register("autocannon_breech", () -> new CannonCastShape(360, 8, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_BREECH_CAST_MOULD, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    public static final RegistryObject<CannonCastShape> AUTOCANNON_RECOIL_SPRING = CANNON_CAST_SHAPES.register("autocannon_recoil_spring", () -> new CannonCastShape(360, 6, (NonNullSupplier<? extends Block>)CBCBlocks.AUTOCANNON_RECOIL_SPRING_CAST_MOULD, false, (PropertySetter<?>[])new PropertySetter[]{PropertySetter.of(BlockStateProperties.f_61372_, Direction.UP)}));
    private final int fluidSize;
    private final int diameter;
    private final NonNullSupplier<? extends Block> castMould;
    private final boolean isLarge;
    private final PropertySetter<?>[] properties;
    private Block resolvedCastMould;

    public CannonCastShape(int fluidSize, int diameter, NonNullSupplier<? extends Block> castMould, PropertySetter<?> ... properties) {
        this(fluidSize, diameter, castMould, true, properties);
    }

    public CannonCastShape(int fluidSize, int diameter, NonNullSupplier<? extends Block> castMould, boolean large, PropertySetter<?> ... properties) {
        this.fluidSize = fluidSize;
        this.diameter = diameter;
        this.castMould = castMould;
        this.isLarge = large;
        this.properties = properties;
    }

    public int fluidSize() {
        return this.fluidSize;
    }

    public int diameter() {
        return this.diameter;
    }

    public boolean isLarge() {
        return this.isLarge;
    }

    public Block castMould() {
        if (this.resolvedCastMould == null) {
            this.resolvedCastMould = (Block)this.castMould.get();
            if (this.resolvedCastMould == null) {
                this.resolvedCastMould = Blocks.f_50016_;
            }
        }
        return this.resolvedCastMould;
    }

    public BlockState applyTo(BlockState state) {
        for (PropertySetter<?> setter : this.properties) {
            state = setter.applyTo(state);
        }
        return state;
    }

    public String toString() {
        return "CannonCastShape[" + CBCRegistries.getRegistry(CBCRegistries.CANNON_CAST_SHAPES_KEY).m_7981_((Object)this) + ",fluidSize=" + this.fluidSize + ",diameter=" + this.diameter + "]";
    }

    public static class PropertySetter<T extends Comparable<T>> {
        private final Property<T> property;
        private final T value;

        public PropertySetter(Property<T> property, T value) {
            this.property = property;
            this.value = value;
        }

        public BlockState applyTo(BlockState state) {
            return state.m_61138_(this.property) ? (BlockState)state.m_61124_(this.property, this.value) : state;
        }

        public static <T extends Comparable<T>> PropertySetter<T> of(Property<T> property, T value) {
            return new PropertySetter<T>(property, value);
        }
    }
}

