/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.datagen.recipes;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import rbasamoyai.createbigcannons.datagen.recipes.BuiltUpHeatingRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.CannonCastRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.DrillBoringRecipeProvider;
import rbasamoyai.createbigcannons.datagen.recipes.FinishedBlockRecipe;

public abstract class BlockRecipeProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DataGenerator gen;
    protected final String modid;
    protected ResourceLocation info;
    protected static final List<BlockRecipeProvider> GENERATORS = new ArrayList<BlockRecipeProvider>();

    public BlockRecipeProvider(String modid, DataGenerator gen) {
        this.modid = modid;
        this.gen = gen;
    }

    public static void registerAll(DataGenerator gen) {
        GENERATORS.add(new CannonCastRecipeProvider(gen));
        GENERATORS.add(new BuiltUpHeatingRecipeProvider(gen));
        GENERATORS.add(new DrillBoringRecipeProvider(gen));
        gen.m_236039_(true, new DataProvider(){

            public void m_213708_(CachedOutput cache) {
                GENERATORS.forEach(gen -> {
                    try {
                        gen.m_213708_(cache);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }

            public String m_6055_() {
                return "Create Big Cannons Block Recipes";
            }
        });
    }

    public void m_213708_(CachedOutput cache) {
        Path path = this.gen.m_123916_();
        HashSet set = new HashSet();
        this.registerRecipes(recipe -> {
            if (!set.add(recipe.id())) {
                throw new IllegalStateException("Duplicate block recipe " + recipe.id());
            }
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)recipe.serializeRecipe(), (Path)path.resolve("data/" + recipe.id().m_135827_() + "/block_recipes/" + recipe.id().m_135815_() + ".json"));
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save block recipe to {}", (Object)path, (Object)e);
            }
        });
    }

    protected abstract void registerRecipes(Consumer<FinishedBlockRecipe> var1);

    public String m_6055_() {
        return "Create Big Cannons Block Recipes: " + (Comparable)((Object)(this.info == null ? "unknown id" : this.info));
    }
}

