/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.manualloading;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import rbasamoyai.createbigcannons.CBCBlocks;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBehavior;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonBlock;
import rbasamoyai.createbigcannons.cannons.big_cannons.BigCannonEnd;
import rbasamoyai.createbigcannons.cannons.big_cannons.IBigCannonBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.big_cannon.ProjectileBlock;

public class RamRodItem
extends Item {
    public static final UUID BASE_ATTACK_KNOCKBACK_UUID = UUID.fromString("bfa4160d-4ef0-4069-9569-3dfd2765f1c6");
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public RamRodItem(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 3.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", -3.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(BASE_ATTACK_KNOCKBACK_UUID, "Tool modifier", 2.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getAttributeModifiers(slot, stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag tag;
        Object cbe;
        BlockPos pos1;
        BlockState state1;
        int i;
        Player player = context.m_43723_();
        if (player instanceof DeployerFakePlayer && !RamRodItem.deployersCanUse()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction pushDirection = context.m_43719_().m_122424_();
        int k = 0;
        if (level.m_7702_(pos) instanceof IBigCannonBlockEntity) {
            k = -1;
            for (int i2 = 0; i2 < RamRodItem.getReach(); ++i2) {
                IBigCannonBlockEntity cbe2;
                StructureTemplate.StructureBlockInfo info;
                BlockPos pos12 = pos.m_5484_(pushDirection, i2);
                BlockState state12 = level.m_8055_(pos12);
                if (state12.m_60795_()) continue;
                if (!RamRodItem.isValidLoadBlock(state12, level, pos12, pushDirection)) {
                    return InteractionResult.FAIL;
                }
                BlockEntity blockEntity = level.m_7702_(pos12);
                if (blockEntity instanceof IBigCannonBlockEntity && ((info = ((BigCannonBehavior)((Object)(cbe2 = (IBigCannonBlockEntity)blockEntity).cannonBehavior())).block()) == null || info.f_74676_ == null || info.f_74676_.m_60795_())) continue;
                k = i2;
                break;
            }
            if (k == -1) {
                return InteractionResult.PASS;
            }
        }
        ArrayList<StructureTemplate.StructureBlockInfo> toPush = new ArrayList<StructureTemplate.StructureBlockInfo>();
        boolean encounteredCannon = false;
        int maxCount = RamRodItem.getPushStrength();
        for (i = 0; i < maxCount + 1 && !(state1 = level.m_8055_(pos1 = pos.m_5484_(pushDirection, i + k))).m_60795_(); ++i) {
            if (!RamRodItem.isValidLoadBlock(state1, level, pos1, pushDirection)) {
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.m_7702_(pos1);
            if (blockEntity instanceof IBigCannonBlockEntity) {
                cbe = (IBigCannonBlockEntity)blockEntity;
                encounteredCannon = true;
                StructureTemplate.StructureBlockInfo info = ((BigCannonBehavior)((Object)cbe.cannonBehavior())).block();
                if (info == null || info.f_74676_ == null || info.f_74676_.m_60795_()) break;
                toPush.add(info);
            } else {
                BlockEntity be = level.m_7702_(pos1);
                tag = null;
                if (be != null) {
                    tag = be.m_187480_();
                    tag.m_128473_("x");
                    tag.m_128473_("y");
                    tag.m_128473_("z");
                }
                toPush.add(new StructureTemplate.StructureBlockInfo(BlockPos.f_121853_, state1, tag));
            }
            if (toPush.size() <= maxCount) continue;
            return InteractionResult.FAIL;
        }
        if (!encounteredCannon || toPush.isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_) {
            for (i = toPush.size() - 1; i >= 0; --i) {
                pos1 = pos.m_5484_(pushDirection, i + k);
                cbe = level.m_7702_(pos1);
                if (cbe instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe3 = (IBigCannonBlockEntity)cbe;
                    ((BigCannonBehavior)((Object)cbe3.cannonBehavior())).removeBlock();
                } else {
                    level.m_7471_(pos1, false);
                }
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)toPush.get(i);
                BlockPos pos2 = pos1.m_121945_(pushDirection);
                tag = level.m_7702_(pos2);
                if (tag instanceof IBigCannonBlockEntity) {
                    IBigCannonBlockEntity cbe4 = (IBigCannonBlockEntity)tag;
                    ((BigCannonBehavior)((Object)cbe4.cannonBehavior())).tryLoadingBlock(info);
                    continue;
                }
                level.m_7731_(pos2, info.f_74676_, 67);
                BlockEntity be = level.m_7702_(pos2);
                CompoundTag tag2 = info.f_74677_;
                if (be != null) {
                    tag2 = NBTProcessors.process((BlockEntity)be, (CompoundTag)tag2, (boolean)false);
                }
                if (be == null || tag2 == null) continue;
                tag2.m_128405_("x", pos2.m_123341_());
                tag2.m_128405_("y", pos2.m_123342_());
                tag2.m_128405_("z", pos2.m_123343_());
                be.m_142466_(tag2);
            }
            level.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.m_36399_((float)toPush.size() * CBCConfigs.SERVER.cannons.loadingToolHungerConsumption.getF());
        player.m_36335_().m_41524_((Item)this, ((Integer)CBCConfigs.SERVER.cannons.loadingToolCooldown.get()).intValue());
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean isValidLoadBlock(BlockState state, Level level, BlockPos pos, Direction dir) {
        if (CBCBlocks.POWDER_CHARGE.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61365_) == dir.m_122434_();
        }
        if (state.m_60734_() instanceof ProjectileBlock) {
            return ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_() == dir.m_122434_();
        }
        Block block = state.m_60734_();
        if (block instanceof BigCannonBlock) {
            BigCannonBlock cBlock = (BigCannonBlock)block;
            return cBlock.getOpeningType(level, state, pos) == BigCannonEnd.OPEN && cBlock.getFacing(state).m_122434_() == dir.m_122434_();
        }
        return false;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendRamRodText(stack, level, tooltip, flag);
    }

    public static int getPushStrength() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodStrength.get();
    }

    public static int getReach() {
        return (Integer)CBCConfigs.SERVER.cannons.ramRodReach.get();
    }

    public static boolean deployersCanUse() {
        return (Boolean)CBCConfigs.SERVER.cannons.deployersCanUseLoadingTools.get();
    }
}

