/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlob;

public class FluidBlobEffectRegistry {
    private static final Map<Fluid, OnHit> ON_HIT = new HashMap<Fluid, OnHit>();
    private static final Map<Fluid, OnHitBlock> ON_HIT_BLOCK = new HashMap<Fluid, OnHitBlock>();
    private static final Map<Fluid, OnHitEntity> ON_HIT_ENTITY = new HashMap<Fluid, OnHitEntity>();

    public static void registerAllHit(Fluid fluid, OnHit cons) {
        ON_HIT.put(fluid, cons);
    }

    public static void effectOnAllHit(FluidBlob projectile, HitResult result) {
        FluidStack stack = projectile.getFluidStack();
        if (stack == null) {
            return;
        }
        OnHit cons = ON_HIT.get(stack.getFluid());
        if (cons != null) {
            cons.hit(stack, projectile, projectile.m_9236_(), result);
        }
    }

    public static void registerHitBlock(Fluid fluid, OnHitBlock cons) {
        ON_HIT_BLOCK.put(fluid, cons);
    }

    public static void effectOnHitBlock(FluidBlob projectile, BlockHitResult result) {
        FluidStack stack = projectile.getFluidStack();
        if (stack == null) {
            return;
        }
        OnHitBlock cons = ON_HIT_BLOCK.get(stack.getFluid());
        if (cons != null) {
            cons.hit(stack, projectile, projectile.m_9236_(), result);
        }
    }

    public static void registerHitEntity(Fluid fluid, OnHitEntity cons) {
        ON_HIT_ENTITY.put(fluid, cons);
    }

    public static void effectOnHitEntity(FluidBlob projectile, EntityHitResult result) {
        FluidStack stack = projectile.getFluidStack();
        if (stack == null) {
            return;
        }
        OnHitEntity cons = ON_HIT_ENTITY.get(stack.getFluid());
        if (cons != null) {
            cons.hit(stack, projectile, projectile.m_9236_(), result);
        }
    }

    public static interface OnHit {
        public void hit(FluidStack var1, FluidBlob var2, Level var3, HitResult var4);
    }

    public static interface OnHitBlock {
        public void hit(FluidStack var1, FluidBlob var2, Level var3, BlockHitResult var4);
    }

    public static interface OnHitEntity {
        public void hit(FluidStack var1, FluidBlob var2, Level var3, EntityHitResult var4);
    }
}

