/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockHardnessHandler {
    public static final Map<Block, Double> TAG_MAP = new HashMap<Block, Double>();
    public static final Map<Block, Double> BLOCK_MAP = new HashMap<Block, Double>();
    public static final Map<TagKey<Block>, Double> TAGS_TO_EVALUATE = new HashMap<TagKey<Block>, Double>();

    public static void loadTags() {
        TAG_MAP.clear();
        for (Map.Entry<TagKey<Block>, Double> entry : TAGS_TO_EVALUATE.entrySet()) {
            double hardness = entry.getValue();
            for (Holder holder : Registry.f_122824_.m_206058_(entry.getKey())) {
                TAG_MAP.put((Block)holder.m_203334_(), hardness);
            }
        }
        TAGS_TO_EVALUATE.clear();
    }

    public static void cleanUp() {
        TAG_MAP.clear();
        BLOCK_MAP.clear();
        TAGS_TO_EVALUATE.clear();
    }

    public static double getHardness(BlockState state) {
        Block block = state.m_60734_();
        if (BLOCK_MAP.containsKey(block)) {
            return BLOCK_MAP.get(block);
        }
        if (TAG_MAP.containsKey(block)) {
            return TAG_MAP.get(block);
        }
        return block.m_7325_();
    }

    public static class ReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "block_hardness");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            BlockHardnessHandler.cleanUp();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    for (Map.Entry objEntry : el.getAsJsonObject().entrySet()) {
                        JsonElement el1 = (JsonElement)objEntry.getValue();
                        if (!el1.isJsonPrimitive() || !el1.getAsJsonPrimitive().isNumber()) continue;
                        String s = (String)objEntry.getKey();
                        double hardness = el1.getAsDouble();
                        if (s.charAt(0) == '#') {
                            s = s.substring(1);
                            TAGS_TO_EVALUATE.put((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(s)), hardness);
                            continue;
                        }
                        String copy = s;
                        Block block = (Block)Registry.f_122824_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown block '" + copy + "'"));
                        BLOCK_MAP.put(block, hardness);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

