/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.fuzes;

import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class ImpactFuzeItem
extends FuzeItem {
    public ImpactFuzeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onProjectileImpact(ItemStack stack, AbstractCannonProjectile projectile, HitResult result) {
        float f = this.getDetonateChance();
        return projectile.getProjectileMass() <= 0.0f && f > 0.0f && projectile.f_19853_.m_213780_().m_188501_() < f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendImpactFuzeText(stack, level, tooltip, flag, this.getDetonateChance());
    }

    protected float getDetonateChance() {
        return CBCConfigs.SERVER.munitions.impactFuzeDetonationChance.getF();
    }

    @Override
    public void addExtraInfo(List<Component> tooltip, boolean isSneaking, ItemStack stack) {
        super.addExtraInfo(tooltip, isSneaking, stack);
        MutableComponent info = Lang.builder((String)"item").translate("createbigcannons.impact_fuze.tooltip.shell_info", new Object[]{(int)(this.getDetonateChance() * 100.0f)}).component();
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)info, (ChatFormatting)ChatFormatting.GRAY, (ChatFormatting)ChatFormatting.GREEN, (int)6));
    }
}

