/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.entity.ImmersivePaintingEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public abstract class PaintingDataMessage
implements Message {
    private static final long serialVersionUID = -6510034100878125474L;
    final String motive;
    final String frame;
    final String material;
    final int entityId;
    private final int facing;
    private final int rotation;
    private final int x;
    private final int y;
    private final int z;

    public PaintingDataMessage(ImmersivePaintingEntity painting) {
        this.entityId = painting.m_19879_();
        this.motive = painting.getMotive().toString();
        this.frame = painting.getFrame().toString();
        this.material = painting.getMaterial().toString();
        this.facing = painting.m_6350_().ordinal();
        this.rotation = painting.getRotation();
        this.x = painting.getAttachmentPos().m_123341_();
        this.y = painting.getAttachmentPos().m_123342_();
        this.z = painting.getAttachmentPos().m_123343_();
    }

    public ResourceLocation getMotive() {
        return new ResourceLocation(this.motive);
    }

    public ResourceLocation getFrame() {
        return new ResourceLocation(this.frame);
    }

    public int getRotation() {
        return this.rotation;
    }

    public ResourceLocation getMaterial() {
        return new ResourceLocation(this.material);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Direction getFacing() {
        return Direction.values()[this.facing];
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

