/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.SerializableNbt;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PaintingListMessage
implements Message {
    private static final long serialVersionUID = 2240894186943896681L;
    private final Map<String, SerializableNbt> paintings = new HashMap<String, SerializableNbt>();
    private final boolean clear;
    private final boolean showOtherPlayersPaintings;

    public PaintingListMessage() {
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.getDatapackPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), new SerializableNbt(entry.getValue().toNbt()));
        }
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.get().getCustomServerPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), new SerializableNbt(entry.getValue().toNbt()));
        }
        this.showOtherPlayersPaintings = Config.getInstance().showOtherPlayersPaintings;
        this.clear = true;
    }

    public PaintingListMessage(ResourceLocation identifier, Painting painting) {
        this.paintings.put(identifier.toString(), painting == null ? null : new SerializableNbt(painting.toNbt()));
        this.showOtherPlayersPaintings = Config.getInstance().showOtherPlayersPaintings;
        this.clear = false;
    }

    @Override
    public void receive(Player e) {
        Main.networkManager.handlePaintingListResponse(this);
    }

    public Map<ResourceLocation, Painting> getPaintings() {
        HashMap<ResourceLocation, Painting> paintings = new HashMap<ResourceLocation, Painting>();
        for (Map.Entry<String, SerializableNbt> entry : this.paintings.entrySet()) {
            ResourceLocation identifier = new ResourceLocation(entry.getKey());
            if (entry.getValue() == null) {
                paintings.put(identifier, null);
                continue;
            }
            paintings.put(identifier, Painting.fromNbt(entry.getValue().getNbt()));
        }
        return paintings;
    }

    public boolean shouldClear() {
        return this.clear;
    }

    public boolean shouldShowOtherPlayersPaintings() {
        return this.showOtherPlayersPaintings;
    }
}

