/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.steam;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.steam.PoweredShaftTileEntity;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineBlock;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineTileEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SteamEngineRenderer
extends SafeTileEntityRenderer<SteamEngineTileEntity> {
    public SteamEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(SteamEngineTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        Float angle = te.getTargetAngle();
        if (angle == null) {
            return;
        }
        BlockState blockState = te.m_58900_();
        Direction facing = SteamEngineBlock.getFacing(blockState);
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftTileEntity shaft = te.getShaft();
        if (shaft != null) {
            axis = KineticTileEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float sine = Mth.m_14031_((float)angle.floatValue());
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        this.transformed(AllBlockPartials.ENGINE_PISTON, blockState, facing, roll90).translate(0.0, piston, 0.0).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllBlockPartials.ENGINE_LINKAGE, blockState, facing, roll90).centre()).translate(0.0, 1.0, 0.0).unCentre()).translate(0.0, piston, 0.0).translate(0.0, 0.25, 0.5).rotateX(sine2 * 23.0f)).translate(0.0, -0.25, -0.5).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllBlockPartials.ENGINE_CONNECTOR, blockState, facing, roll90).translate(0.0, 2.0, 0.0).centre()).rotateXRadians(-angle.floatValue() + 1.5707964f)).unCentre()).light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, BlockState blockState, Direction facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial(model, blockState).centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(AngleHelper.verticalAngle(facing) + 90.0f)).rotateY(roll90 ? -90.0 : 0.0)).unCentre();
    }

    public int m_142163_() {
        return 128;
    }
}

