/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ITransformableTE;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;

public class StructureTransform {
    public Direction.Axis rotationAxis;
    public BlockPos offset;
    public int angle;
    public Rotation rotation;
    public Mirror mirror;

    private StructureTransform(BlockPos offset, int angle, Direction.Axis axis, Rotation rotation, Mirror mirror) {
        this.offset = offset;
        this.angle = angle;
        this.rotationAxis = axis;
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public StructureTransform(BlockPos offset, Direction.Axis axis, Rotation rotation, Mirror mirror) {
        this(offset, rotation == Rotation.NONE ? 0 : (4 - rotation.ordinal()) * 90, axis, rotation, mirror);
    }

    public StructureTransform(BlockPos offset, float xRotation, float yRotation, float zRotation) {
        this.offset = offset;
        if (xRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.X;
            this.angle = Math.round(xRotation / 90.0f) * 90;
        }
        if (yRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.Y;
            this.angle = Math.round(yRotation / 90.0f) * 90;
        }
        if (zRotation != 0.0f) {
            this.rotationAxis = Direction.Axis.Z;
            this.angle = Math.round(zRotation / 90.0f) * 90;
        }
        this.angle %= 360;
        if (this.angle < -90) {
            this.angle += 360;
        }
        this.rotation = Rotation.NONE;
        if (this.angle == -90 || this.angle == 270) {
            this.rotation = Rotation.CLOCKWISE_90;
        }
        if (this.angle == 90) {
            this.rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.angle == 180) {
            this.rotation = Rotation.CLOCKWISE_180;
        }
        this.mirror = Mirror.NONE;
    }

    public Vec3 applyWithoutOffsetUncentered(Vec3 localVec) {
        Vec3 vec = localVec;
        if (this.mirror != null) {
            vec = VecHelper.mirror(vec, this.mirror);
        }
        if (this.rotationAxis != null) {
            vec = VecHelper.rotate(vec, this.angle, this.rotationAxis);
        }
        return vec;
    }

    public Vec3 applyWithoutOffset(Vec3 localVec) {
        Vec3 vec = localVec;
        if (this.mirror != null) {
            vec = VecHelper.mirrorCentered(vec, this.mirror);
        }
        if (this.rotationAxis != null) {
            vec = VecHelper.rotateCentered(vec, this.angle, this.rotationAxis);
        }
        return vec;
    }

    public Vec3 apply(Vec3 localVec) {
        return this.applyWithoutOffset(localVec).m_82549_(Vec3.m_82528_((Vec3i)this.offset));
    }

    public BlockPos applyWithoutOffset(BlockPos localPos) {
        return new BlockPos(this.applyWithoutOffset(VecHelper.getCenterOf((Vec3i)localPos)));
    }

    public BlockPos apply(BlockPos localPos) {
        return this.applyWithoutOffset(localPos).m_121955_((Vec3i)this.offset);
    }

    public void apply(BlockEntity te) {
        if (te instanceof ITransformableTE) {
            ((ITransformableTE)te).transform(this);
        }
    }

    public BlockState apply(BlockState state) {
        boolean halfTurn;
        Block block = state.m_60734_();
        if (block instanceof ITransformableBlock) {
            ITransformableBlock transformable = (ITransformableBlock)block;
            return transformable.transform(state, this);
        }
        if (this.mirror != null) {
            state = state.m_60715_(this.mirror);
        }
        if (this.rotationAxis == Direction.Axis.Y) {
            if (block instanceof BellBlock) {
                if (state.m_61143_((Property)BlockStateProperties.f_61377_) == BellAttachType.DOUBLE_WALL) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61377_, (Comparable)BellAttachType.SINGLE_WALL);
                }
                return (BlockState)state.m_61124_((Property)BellBlock.f_49679_, (Comparable)this.rotation.m_55954_((Direction)state.m_61143_((Property)BellBlock.f_49679_)));
            }
            return state.m_60717_(this.rotation);
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock) {
            Direction forcedAxis;
            DirectionProperty facingProperty = FaceAttachedHorizontalDirectionalBlock.f_54117_;
            EnumProperty faceProperty = FaceAttachedHorizontalDirectionalBlock.f_53179_;
            Direction stateFacing = (Direction)state.m_61143_((Property)facingProperty);
            AttachFace stateFace = (AttachFace)state.m_61143_((Property)faceProperty);
            Direction direction = forcedAxis = this.rotationAxis == Direction.Axis.Z ? Direction.EAST : Direction.SOUTH;
            if (stateFacing.m_122434_() == this.rotationAxis && stateFace == AttachFace.WALL) {
                return state;
            }
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                stateFace = (AttachFace)state.m_61143_((Property)faceProperty);
                stateFacing = (Direction)state.m_61143_((Property)facingProperty);
                boolean b = state.m_61143_((Property)faceProperty) == AttachFace.CEILING;
                state = (BlockState)state.m_61124_((Property)facingProperty, (Comparable)(b ? forcedAxis : forcedAxis.m_122424_()));
                state = stateFace != AttachFace.WALL ? (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.WALL) : (stateFacing.m_122421_() == Direction.AxisDirection.POSITIVE ? (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.FLOOR) : (BlockState)state.m_61124_((Property)faceProperty, (Comparable)AttachFace.CEILING));
            }
            return state;
        }
        boolean bl = halfTurn = this.rotation == Rotation.CLOCKWISE_180;
        if (block instanceof StairBlock) {
            state = this.transformStairs(state, halfTurn);
            return state;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)this.rotateFacing((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.rotateAxis((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)));
        } else if (halfTurn) {
            Direction stateFacing;
            if (state.m_61138_((Property)BlockStateProperties.f_61374_) && (stateFacing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == this.rotationAxis) {
                return state;
            }
            if ((state = state.m_60717_(this.rotation)).m_61138_((Property)SlabBlock.f_56353_) && state.m_61143_((Property)SlabBlock.f_56353_) != SlabType.DOUBLE) {
                state = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM));
            }
        }
        return state;
    }

    protected BlockState transformStairs(BlockState state, boolean halfTurn) {
        if (((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122434_() != this.rotationAxis) {
            for (int i = 0; i < this.rotation.ordinal(); ++i) {
                Direction direction = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
                Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
                state = direction.m_122421_() == Direction.AxisDirection.POSITIVE ^ half == Half.BOTTOM ^ direction.m_122434_() == Direction.Axis.Z ? (BlockState)state.m_61122_((Property)StairBlock.f_56842_) : (BlockState)state.m_61124_((Property)StairBlock.f_56841_, (Comparable)direction.m_122424_());
            }
        } else if (halfTurn) {
            state = (BlockState)state.m_61122_((Property)StairBlock.f_56842_);
        }
        return state;
    }

    public Direction mirrorFacing(Direction facing) {
        if (this.mirror != null) {
            return this.mirror.m_54848_(facing);
        }
        return facing;
    }

    public Direction.Axis rotateAxis(Direction.Axis axis) {
        Direction facing = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        return this.rotateFacing(facing).m_122434_();
    }

    public Direction rotateFacing(Direction facing) {
        for (int i = 0; i < this.rotation.ordinal(); ++i) {
            facing = facing.m_175362_(this.rotationAxis);
        }
        return facing;
    }

    public static StructureTransform fromBuffer(FriendlyByteBuf buffer) {
        BlockPos readBlockPos = buffer.m_130135_();
        int readAngle = buffer.readInt();
        int axisIndex = buffer.m_130242_();
        int rotationIndex = buffer.m_130242_();
        int mirrorIndex = buffer.m_130242_();
        return new StructureTransform(readBlockPos, readAngle, axisIndex == -1 ? null : Direction.Axis.values()[axisIndex], rotationIndex == -1 ? null : Rotation.values()[rotationIndex], mirrorIndex == -1 ? null : Mirror.values()[mirrorIndex]);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.offset);
        buffer.writeInt(this.angle);
        buffer.m_130130_(this.rotationAxis == null ? -1 : this.rotationAxis.ordinal());
        buffer.m_130130_(this.rotation == null ? -1 : this.rotation.ordinal());
        buffer.m_130130_(this.mirror == null ? -1 : this.mirror.ordinal());
    }
}

