/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemStackHandler;

public class SharedDepotBlockMethods {
    protected static DepotBehaviour get(BlockGetter worldIn, BlockPos pos) {
        return TileEntityBehaviour.get(worldIn, pos, DepotBehaviour.TYPE);
    }

    public static InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (ray.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        DepotBehaviour behaviour = SharedDepotBlockMethods.get((BlockGetter)world, pos);
        if (behaviour == null) {
            return InteractionResult.PASS;
        }
        if (!behaviour.canAcceptItems.get().booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        boolean wasEmptyHanded = heldItem.m_41619_();
        boolean shouldntPlaceItem = AllBlocks.MECHANICAL_ARM.isIn(heldItem);
        ItemStack mainItemStack = behaviour.getHeldItemStack();
        if (!mainItemStack.m_41619_()) {
            player.m_150109_().m_150079_(mainItemStack);
            behaviour.removeHeldItem();
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, 1.0f + Create.RANDOM.nextFloat());
        }
        ItemStackHandler outputs = behaviour.processingOutputBuffer;
        for (int i = 0; i < outputs.getSlots(); ++i) {
            player.m_150109_().m_150079_(outputs.extractItem(i, 64, false));
        }
        if (!wasEmptyHanded && !shouldntPlaceItem) {
            TransportedItemStack transported = new TransportedItemStack(heldItem);
            transported.insertedFrom = player.m_6350_();
            transported.prevBeltPosition = 0.25f;
            transported.beltPosition = 0.25f;
            behaviour.setHeldItem(transported);
            player.m_21008_(hand, ItemStack.f_41583_);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(world, (Vec3i)pos);
        }
        behaviour.tileEntity.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public static void onLanded(BlockGetter worldIn, Entity entityIn) {
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        if (entityIn.f_19853_.f_46443_) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get(worldIn, entityIn.m_20183_(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.m_32055_(), Direction.DOWN, false);
        itemEntity.m_32045_(remainder);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
    }

    public static int getComparatorInputOverride(BlockState blockState, Level worldIn, BlockPos pos) {
        DepotBehaviour depotBehaviour = SharedDepotBlockMethods.get((BlockGetter)worldIn, pos);
        if (depotBehaviour == null) {
            return 0;
        }
        float f = depotBehaviour.getPresentStackSize();
        Integer max = depotBehaviour.maxStackSize.get();
        return Mth.m_14045_((int)(Mth.m_14143_((float)((f /= (float)(max == 0 ? 64 : max)) * 14.0f)) + (f > 0.0f ? 1 : 0)), (int)0, (int)15);
    }
}

