/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemNameAttribute
implements ItemAttribute {
    String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        String name = this.extractCustomName(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new ItemNameAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        nbt.m_128359_("name", this.itemName);
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return new ItemNameAttribute(nbt.m_128461_("name"));
    }

    private String extractCustomName(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        if (compoundnbt != null && compoundnbt.m_128425_("Name", 8)) {
            try {
                MutableComponent itextcomponent = Component.Serializer.m_130701_((String)compoundnbt.m_128461_("Name"));
                if (itextcomponent != null) {
                    return itextcomponent.getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }
}

