/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.render.BakedModelRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.AngleHelper;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class CachedBufferer {
    public static final SuperByteBufferCache.Compartment<BlockState> GENERIC_TILE = new SuperByteBufferCache.Compartment();
    public static final SuperByteBufferCache.Compartment<PartialModel> PARTIAL = new SuperByteBufferCache.Compartment();
    public static final SuperByteBufferCache.Compartment<Pair<Direction, PartialModel>> DIRECTIONAL_PARTIAL = new SuperByteBufferCache.Compartment();

    public static SuperByteBuffer block(BlockState toRender) {
        return CachedBufferer.block(GENERIC_TILE, toRender);
    }

    public static SuperByteBuffer block(SuperByteBufferCache.Compartment<BlockState> compartment, BlockState toRender) {
        return CreateClient.BUFFER_CACHE.get(compartment, toRender, () -> BakedModelRenderHelper.standardBlockRender(toRender));
    }

    public static SuperByteBuffer partial(PartialModel partial, BlockState referenceState) {
        return CreateClient.BUFFER_CACHE.get(PARTIAL, partial, () -> BakedModelRenderHelper.standardModelRender(partial.get(), referenceState));
    }

    public static SuperByteBuffer partial(PartialModel partial, BlockState referenceState, Supplier<PoseStack> modelTransform) {
        return CreateClient.BUFFER_CACHE.get(PARTIAL, partial, () -> BakedModelRenderHelper.standardModelRender(partial.get(), referenceState, (PoseStack)modelTransform.get()));
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, BlockState referenceState) {
        Direction facing = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61372_);
        return CachedBufferer.partialFacing(partial, referenceState, facing);
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, BlockState referenceState, Direction facing) {
        return CachedBufferer.partialDirectional(partial, referenceState, facing, CachedBufferer.rotateToFace(facing));
    }

    public static SuperByteBuffer partialFacingVertical(PartialModel partial, BlockState referenceState, Direction facing) {
        return CachedBufferer.partialDirectional(partial, referenceState, facing, CachedBufferer.rotateToFaceVertical(facing));
    }

    public static SuperByteBuffer partialDirectional(PartialModel partial, BlockState referenceState, Direction dir, Supplier<PoseStack> modelTransform) {
        return CreateClient.BUFFER_CACHE.get(DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> BakedModelRenderHelper.standardModelRender(partial.get(), referenceState, (PoseStack)modelTransform.get()));
    }

    public static Supplier<PoseStack> rotateToFace(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)stack).centre()).rotateY((double)AngleHelper.horizontalAngle(facing))).rotateX((double)AngleHelper.verticalAngle(facing))).unCentre();
            return stack;
        };
    }

    public static Supplier<PoseStack> rotateToFaceVertical(Direction facing) {
        return () -> {
            PoseStack stack = new PoseStack();
            ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)stack).centre()).rotateY((double)AngleHelper.horizontalAngle(facing))).rotateX((double)(AngleHelper.verticalAngle(facing) + 90.0f))).unCentre();
            return stack;
        };
    }
}

