/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.DynamicDataProvider;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.worldgen.AllLayerPatterns;
import com.simibubi.create.foundation.worldgen.OreFeatureConfigEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AllOreFeatureConfigEntries {
    public static final OreFeatureConfigEntry ZINC_ORE = AllOreFeatureConfigEntries.create("zinc_ore", 12, 8.0f, -63, 70).standardDatagenExt().withBlocks(Couple.create(AllBlocks.ZINC_ORE, AllBlocks.DEEPSLATE_ZINC_ORE)).biomeTag(BiomeTags.f_215817_).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_OVERWORLD = AllOreFeatureConfigEntries.create("striated_ores_overworld", 32, 0.083333336f, -30, 70).layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE).biomeTag(BiomeTags.f_215817_).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_NETHER = AllOreFeatureConfigEntries.create("striated_ores_nether", 32, 0.083333336f, 40, 90).layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER).biomeTag(BiomeTags.f_207612_).parent();

    private static OreFeatureConfigEntry create(String name, int clusterSize, float frequency, int minHeight, int maxHeight) {
        ResourceLocation id = Create.asResource(name);
        OreFeatureConfigEntry configDrivenFeatureEntry = new OreFeatureConfigEntry(id, clusterSize, frequency, minHeight, maxHeight);
        return configDrivenFeatureEntry;
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder, String namespace) {
        OreFeatureConfigEntry.ALL.forEach((id, entry) -> {
            if (id.m_135827_().equals(namespace)) {
                builder.push(entry.getName());
                entry.addToConfig(builder);
                builder.pop();
            }
        });
    }

    public static void init() {
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryAccess registryAccess = (RegistryAccess)RegistryAccess.f_123049_.get();
        HashMap configuredFeatures = new HashMap();
        for (Map.Entry<ResourceLocation, OreFeatureConfigEntry> entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = entry.getValue().datagenExt();
            if (datagenExt == null) continue;
            configuredFeatures.put(entry.getKey(), datagenExt.createConfiguredFeature(registryAccess));
        }
        DynamicDataProvider configuredFeatureProvider = DynamicDataProvider.create(generator, "Create's Configured Features", registryAccess, Registry.f_122881_, configuredFeatures);
        if (configuredFeatureProvider != null) {
            generator.m_236039_(true, configuredFeatureProvider);
        }
        HashMap<ResourceLocation, PlacedFeature> placedFeatures = new HashMap<ResourceLocation, PlacedFeature>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            placedFeatures.put((ResourceLocation)entry.getKey(), datagenExt.createPlacedFeature(registryAccess));
        }
        DynamicDataProvider placedFeatureProvider = DynamicDataProvider.create(generator, "Create's Placed Features", registryAccess, Registry.f_194567_, placedFeatures);
        if (placedFeatureProvider != null) {
            generator.m_236039_(true, placedFeatureProvider);
        }
        HashMap<ResourceLocation, BiomeModifier> hashMap = new HashMap<ResourceLocation, BiomeModifier>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            hashMap.put((ResourceLocation)entry.getKey(), datagenExt.createBiomeModifier(registryAccess));
        }
        DynamicDataProvider biomeModifierProvider = DynamicDataProvider.create(generator, "Create's Biome Modifiers", registryAccess, ForgeRegistries.Keys.BIOME_MODIFIERS, hashMap);
        if (biomeModifierProvider != null) {
            generator.m_236039_(true, biomeModifierProvider);
        }
    }
}

