/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.recipe;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.recipe.IRecipeInput;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ThingsRecipeInput
implements IRecipeInput {
    @Nonnull
    private final Things things;
    private final int slot;
    private final float multiplier;
    private int stackSize;

    public ThingsRecipeInput(@Nonnull Things things) {
        this(things, -1);
    }

    public ThingsRecipeInput(@Nonnull Things things, int slot) {
        this(things, slot, 1.0f);
    }

    public ThingsRecipeInput(@Nonnull Things things, int slot, float multiplier) {
        this(things, 1, slot, multiplier);
    }

    public ThingsRecipeInput(@Nonnull Things things, int stackSize, int slot, float multiplier) {
        this.things = things;
        this.stackSize = stackSize;
        this.slot = slot;
        this.multiplier = multiplier;
    }

    @Nonnull
    public ThingsRecipeInput setCount(int count) {
        this.stackSize = count;
        return this;
    }

    @Override
    @Nonnull
    public ThingsRecipeInput copy() {
        return new ThingsRecipeInput(this.things, this.stackSize, this.slot, this.multiplier);
    }

    @Override
    public boolean isFluid() {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getInput() {
        ItemStack itemStack = this.things.getItemStack().func_77946_l();
        itemStack.func_190920_e(this.stackSize);
        return itemStack;
    }

    @Override
    public FluidStack getFluidInput() {
        return null;
    }

    @Override
    public float getMulitplier() {
        return this.multiplier;
    }

    @Override
    public int getSlotNumber() {
        return this.slot;
    }

    @Override
    public boolean isInput(@Nonnull ItemStack test) {
        return this.things.contains(test);
    }

    @Override
    public boolean isInput(FluidStack test) {
        return false;
    }

    @Override
    public ItemStack[] getEquivelentInputs() {
        ItemStack[] result = (ItemStack[])this.things.getItemStacksRaw().toArray((Object[])new ItemStack[0]);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].func_77946_l();
            result[i].func_190920_e(this.stackSize);
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.stackSize > 0 && this.things.isPotentiallyValid();
    }

    @Override
    public void shrinkStack(int count) {
        this.stackSize -= count;
    }

    @Override
    public int getStackSize() {
        return this.stackSize;
    }
}

