/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.capability;

import crazypants.enderio.base.capability.LegacyMachineWrapper;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import crazypants.enderio.util.Prep;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;

public class LegacyStirlingWrapper
extends LegacyMachineWrapper {
    public LegacyStirlingWrapper(@Nonnull TileStirlingGenerator machine, @Nonnull EnumFacing side) {
        super(machine, side);
    }

    private boolean hasBucket() {
        ItemStack stack = this.machine.getStackInSlot(this.machine.getSlotDefinition().getMinInputSlot());
        return Prep.isValid(stack) && !TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public int getSlots() {
        IoMode ioMode = this.machine.getIoMode(this.side);
        if (ioMode.canRecieveInput() || ioMode.canOutput() && this.hasBucket()) {
            return this.machine.getSlotDefinition().getNumInputSlots();
        }
        return 0;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int external, int amount, boolean simulate) {
        if (amount > 0 && external == 0 && this.machine.getIoMode(this.side).canOutput() && this.hasBucket()) {
            return this.doExtractItem(this.machine.getSlotDefinition().getMinInputSlot(), amount, simulate);
        }
        return Prep.getEmpty();
    }
}

