/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.render;

import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.base.te.AbstractMachineEntity;
import crazypants.enderio.base.material.material.Material;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machines.machine.obelisk.aversion.AversionObeliskRenderer;
import crazypants.enderio.machines.machine.obelisk.aversion.TileAversionObelisk;
import crazypants.enderio.machines.machine.obelisk.inhibitor.TileInhibitorObelisk;
import crazypants.enderio.machines.machine.obelisk.relocator.RelocatorObeliskRenderer;
import crazypants.enderio.machines.machine.obelisk.relocator.TileRelocatorObelisk;
import crazypants.enderio.machines.machine.obelisk.render.ObeliskSpecialRenderer;
import crazypants.enderio.machines.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machines.machine.obelisk.weather.WeatherObeliskSpecialRenderer;
import crazypants.enderio.machines.machine.obelisk.xp.TileExperienceObelisk;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="enderiomachines", value={Side.CLIENT})
public class ObeliskRenderManager {
    @Nonnull
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("enderio:obelisk");
    @Nonnull
    private static final TextureRegistry.TextureSupplier[] textures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obelisk_bottom"), TextureRegistry.registerTexture("blocks/block_soul_machine_top"), TextureRegistry.registerTexture("blocks/block_attractor_side"), TextureRegistry.registerTexture("blocks/block_attractor_side"), TextureRegistry.registerTexture("blocks/block_attractor_side"), TextureRegistry.registerTexture("blocks/block_attractor_side")};
    @Nonnull
    private static final TextureRegistry.TextureSupplier[] activeTextures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obelisk_bottom"), TextureRegistry.registerTexture("blocks/block_soul_machine_top"), TextureRegistry.registerTexture("blocks/block_attractor_side_on"), TextureRegistry.registerTexture("blocks/block_attractor_side_on"), TextureRegistry.registerTexture("blocks/block_attractor_side_on"), TextureRegistry.registerTexture("blocks/block_attractor_side_on")};

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(ModelRegistryEvent event) {
        ObeliskSpecialRenderer eor;
        Block block = MachineObject.block_experience_obelisk.getBlock();
        if (block != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(ModObject.itemXpTransfer.getItemNN()), block);
            ObeliskRenderManager.registerRenderer(block, TileExperienceObelisk.class, eor);
        }
        if ((block = MachineObject.block_attractor_obelisk.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(Material.ATTRACTOR_CRYSTAL.getStack(), block);
            ObeliskRenderManager.registerRenderer(block, TileAttractor.class, eor);
        }
        if ((block = MachineObject.block_aversion_obelisk.getBlock()) != null) {
            eor = new AversionObeliskRenderer();
            ObeliskRenderManager.registerRenderer(block, TileAversionObelisk.class, eor);
        }
        if ((block = MachineObject.block_relocator_obelisk.getBlock()) != null) {
            eor = new RelocatorObeliskRenderer();
            ObeliskRenderManager.registerRenderer(block, TileRelocatorObelisk.class, eor);
        }
        if ((block = MachineObject.block_weather_obelisk.getBlock()) != null) {
            eor = new WeatherObeliskSpecialRenderer(new ItemStack(Items.field_151152_bP));
            ObeliskRenderManager.registerRenderer(block, TileWeatherObelisk.class, eor);
        }
        if ((block = MachineObject.block_inhibitor_obelisk.getBlock()) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(Items.field_151079_bi), block);
            ObeliskRenderManager.registerRenderer(block, TileInhibitorObelisk.class, eor);
        }
    }

    private static <T extends AbstractMachineEntity> void registerRenderer(@Nonnull Block block, Class<T> tileClass, TileEntitySpecialRenderer<? super T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, specialRenderer);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)block), (int)0, tileClass);
    }

    @Nonnull
    public static TextureRegistry.TextureSupplier[] getTextures() {
        return textures;
    }

    @Nonnull
    public static TextureRegistry.TextureSupplier[] getActiveTextures() {
        return activeTextures;
    }
}

