/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.network.OpenContainerPacket;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommonUtils {
    private static final Field modControllerField;
    private static final Field eventChannelsField;
    private static MinecraftServer server;

    static void initialize() {
        EventBus eventBus = CommonUtils.getEventBus("supermartijn642corelib");
        eventBus.register(new Object(){

            @Subscribe
            public void serverAboutToStart(FMLServerAboutToStartEvent e) {
                server = e.getServer();
            }

            @Subscribe
            public void serverStopped(FMLServerStoppedEvent e) {
                server = null;
            }
        });
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static World getLevel(DimensionType dimensionType) {
        MinecraftServer server = CommonUtils.getServer();
        return server == null ? null : server.func_71218_a(dimensionType.func_186068_a());
    }

    public static CoreSide getEnvironmentSide() {
        return CoreSide.fromUnderlying(FMLCommonHandler.instance().getSide());
    }

    public static boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public static EventBus getEventBus(String modid) {
        try {
            LoadController modController = (LoadController)modControllerField.get(Loader.instance());
            Map eventChannels = (Map)eventChannelsField.get(modController);
            return (EventBus)eventChannels.get(modid);
        }
        catch (Exception e) {
            CoreLib.LOGGER.error("Encountered an error whilst trying to obtain internal event bus for modid '" + modid + "'!", (Throwable)e);
            return null;
        }
    }

    public static void openContainer(BaseContainer container) {
        EntityPlayer player = container.player;
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ((EntityPlayerMP)player).func_71117_bO();
        ((EntityPlayerMP)player).func_71128_l();
        CoreLib.CHANNEL.sendToPlayer(player, new OpenContainerPacket<BaseContainer>(container, ((EntityPlayerMP)player).field_71139_cq));
        player.field_71070_bA = container;
        container.field_75152_c = ((EntityPlayerMP)player).field_71139_cq;
        container.func_75132_a((IContainerListener)((EntityPlayerMP)player));
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, (Container)container));
    }

    static {
        try {
            modControllerField = Loader.class.getDeclaredField("modController");
            modControllerField.setAccessible(true);
            eventChannelsField = LoadController.class.getDeclaredField("eventChannels");
            eventChannelsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

