/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.extensions.IngredientExtension;
import com.supermartijn642.core.registry.Registries;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.crafting.IngredientNBT;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={IngredientNBT.class})
public class IngredientNBTMixin
implements IngredientExtension {
    @Shadow(remap=false)
    @Final
    private ItemStack stack;

    @Override
    public JsonElement coreLibSerialize() {
        if (this.getClass() != IngredientNBT.class) {
            throw new RuntimeException("Ingredient class '" + this.getClass().getCanonicalName() + "' does not override IngredientExtension#coreLibSerialize and thus is not supported!");
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:item_nbt");
        json.addProperty("item", Registries.ITEMS.getIdentifier(this.stack.func_77973_b()).toString());
        if (this.stack.func_77981_g()) {
            json.addProperty("data", (Number)this.stack.func_77960_j());
        }
        if (this.stack.func_190916_E() != 1) {
            json.addProperty("count", (Number)this.stack.func_190916_E());
        }
        if (this.stack.func_77942_o()) {
            json.addProperty("nbt", this.stack.func_77978_p().toString());
        }
        return json;
    }
}

