/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.util;

import java.util.function.Function;

public abstract class Maybe<T> {
    private static final Maybe<?> EMPTY = new Empty();

    public static <T> Maybe<T> of(T object) {
        return new Present(object);
    }

    public static <T> Maybe<T> empty() {
        return EMPTY;
    }

    private Maybe() {
    }

    public abstract boolean isPresent();

    public abstract <S> Maybe<S> map(Function<T, S> var1);

    public abstract T get() throws IllegalStateException;

    private static class Empty
    extends Maybe<Object> {
        private Empty() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("Cannot call get on an empty maybe!");
        }

        @Override
        public <S> Maybe<S> map(Function<Object, S> mapper) {
            return this;
        }
    }

    private static class Present<T>
    extends Maybe<T> {
        private final T object;

        private Present(T object) {
            this.object = object;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public <S> Maybe<S> map(Function<T, S> mapper) {
            return Maybe.of(mapper.apply(this.object));
        }

        @Override
        public T get() {
            return this.object;
        }
    }
}

