/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStuckHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class CitizenStuckHandler
implements ICitizenStuckHandler {
    private final AbstractEntityCitizen citizen;
    private int movingAwayAttempts = 0;
    private int stuckTime = 0;

    public CitizenStuckHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    public void func_73660_a() {
        if (this.citizen.getTicksExisted() % 20 == 0) {
            this.checkIfStuck();
            if (this.citizen.getTicksExisted() % 2400 == 0) {
                this.movingAwayAttempts = 0;
            }
        }
    }

    @Override
    public boolean isStuck() {
        return this.stuckTime >= 5 + this.citizen.getRandom().nextInt(5) && this.movingAwayAttempts > 3;
    }

    private void checkIfStuck() {
        if (this.handleCitizenNotStuck()) {
            return;
        }
        ++this.stuckTime;
        if (this.resetWhenCitizenNotStuck()) {
            return;
        }
        if (this.handleCitizenStuck()) {
            return;
        }
        this.citizen.setCurrentPosition(this.citizen.func_180425_c());
    }

    private boolean handleCitizenNotStuck() {
        if (this.citizen.getCurrentPosition() == null) {
            this.citizen.setCurrentPosition(this.citizen.func_180425_c());
            return true;
        }
        if (this.citizen.getNavigator().getDestination() == null || this.citizen.getNavigator().getDestination().func_177954_c((double)this.citizen.func_180425_c().func_177958_n(), (double)this.citizen.func_180425_c().func_177956_o(), (double)this.citizen.func_180425_c().func_177952_p()) < 6.0) {
            this.stuckTime = 0;
            return true;
        }
        if (!new AxisAlignedBB(this.citizen.getCurrentPosition()).func_72321_a(1.0, 1.0, 1.0).func_72326_a(new AxisAlignedBB(this.citizen.func_180425_c())) && this.movingAwayAttempts <= 3) {
            this.stuckTime = 0;
            this.citizen.setCurrentPosition(this.citizen.func_180425_c());
            return true;
        }
        return false;
    }

    private boolean resetWhenCitizenNotStuck() {
        if (this.stuckTime >= 5 + this.citizen.getRandom().nextInt(5) && this.movingAwayAttempts <= 3) {
            this.stuckTime = 0;
            ++this.movingAwayAttempts;
            this.citizen.getNavigator().moveAwayFromXYZ(this.citizen.getCurrentPosition(), 3 + this.citizen.getRandom().nextInt(6), 1.0);
            return true;
        }
        return false;
    }

    private boolean handleCitizenStuck() {
        if (this.stuckTime >= 120) {
            if (this.citizen.getNavigator().getDestination().func_177954_c((double)this.citizen.func_180425_c().func_177958_n(), (double)this.citizen.func_180425_c().func_177956_o(), (double)this.citizen.func_180425_c().func_177952_p()) < 6.0 || this.citizen.getNavigator().getDestination().func_177956_o() - this.citizen.func_180425_c().func_177956_o() > 2) {
                this.stuckTime = 0;
                return true;
            }
            this.movingAwayAttempts = 0;
            this.handleStuckCitizenTeleport();
        }
        return false;
    }

    private void handleStuckCitizenTeleport() {
        BlockPos destination = BlockPosUtil.getFloor(this.citizen.getNavigator().getDestination().func_177984_a(), CompatibilityUtils.getWorldFromCitizen(this.citizen));
        BlockPos spawnPoint = Utils.scanForBlockNearPoint(CompatibilityUtils.getWorldFromCitizen(this.citizen), destination, 1, 1, 1, 3, new Block[]{Blocks.field_150350_a, Blocks.field_150431_aC, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N, Blocks.field_150404_cg});
        WorkerUtil.setSpawnPoint(spawnPoint, this.citizen);
        if (this.citizen.getCitizenColonyHandler().getColony() != null) {
            Log.getLogger().info("Teleported stuck citizen " + this.citizen.func_70005_c_() + " from colony: " + this.citizen.getCitizenColonyHandler().getColonyId() + " to target location");
        }
        this.stuckTime = 0;
    }
}

