/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.timer;

import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.TickOrderHandler;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class TimerTileEntity
extends LogicTileEntity
implements ITickable,
TickOrderHandler.ICheckStateServer {
    public static final String CMD_SETDELAY = "timer.setDelay";
    public static final String CMD_SETPAUSES = "timer.setPauses";
    private boolean prevIn = false;
    private int delay = 20;
    private int timer = 0;
    private boolean redstonePauses = false;

    public int getDelay() {
        return this.delay;
    }

    public int getTimer() {
        return this.timer;
    }

    public boolean getRedstonePauses() {
        return this.redstonePauses;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.markDirtyClient();
    }

    public void setRedstonePauses(boolean redstonePauses) {
        this.redstonePauses = redstonePauses;
        if (redstonePauses && this.powerLevel > 0) {
            this.timer = this.delay;
        }
        this.markDirtyClient();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            TickOrderHandler.queueTimer(this);
        }
    }

    @Override
    public void checkStateServer() {
        int newout;
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (pulse) {
            this.timer = this.delay;
        }
        if (!this.redstonePauses || !this.prevIn) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = this.delay;
            newout = 15;
        } else {
            newout = 0;
        }
        this.setRedstoneState(newout);
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.getDimension();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.delay = tagCompound.func_74762_e("delay");
        this.redstonePauses = tagCompound.func_74767_n("redstonePauses");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("delay", this.delay);
        tagCompound.func_74757_a("redstonePauses", this.redstonePauses);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            int delay;
            String text = (String)params.get(TextField.PARAM_TEXT);
            try {
                delay = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                delay = 1;
            }
            this.setDelay(delay);
            return true;
        }
        if (CMD_SETPAUSES.equals(command)) {
            Boolean on = (Boolean)params.get(ToggleButton.PARAM_ON);
            this.setRedstonePauses(on);
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextFormatting.GREEN + "Time: " + TextFormatting.WHITE + this.getTimer());
    }
}

