/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class SimpleDialerTileEntity
extends LogicTileEntity {
    private GlobalCoordinate transmitter;
    private Integer receiver;
    private boolean onceMode = false;
    private boolean prevIn = false;

    public void update() {
        if (this.transmitter == null) {
            return;
        }
        if (this.powerLevel > 0 == this.prevIn) {
            return;
        }
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (this.powerLevel > 0) {
            int dial;
            GlobalCoordinate gc;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.func_145831_w());
            BlockPos coordinate = null;
            int dim = 0;
            if (this.receiver != null && (gc = destinations.getCoordinateForId(this.receiver)) != null) {
                coordinate = gc.getCoordinate();
                dim = gc.getDimension();
            }
            if ((dial = TeleportationTools.dial(this.func_145831_w(), null, null, this.transmitter.getCoordinate(), this.transmitter.getDimension(), coordinate, dim, this.onceMode)) != 0) {
                // empty if block
            }
        }
    }

    public boolean isOnceMode() {
        return this.onceMode;
    }

    public void setOnceMode(boolean onceMode) {
        this.onceMode = onceMode;
        this.markDirtyClient();
    }

    public GlobalCoordinate getTransmitter() {
        return this.transmitter;
    }

    public Integer getReceiver() {
        return this.receiver;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.transmitter = tagCompound.func_74764_b("transX") ? new GlobalCoordinate(new BlockPos(tagCompound.func_74762_e("transX"), tagCompound.func_74762_e("transY"), tagCompound.func_74762_e("transZ")), tagCompound.func_74762_e("transDim")) : null;
        this.receiver = tagCompound.func_74764_b("receiver") ? Integer.valueOf(tagCompound.func_74762_e("receiver")) : null;
        this.onceMode = tagCompound.func_74767_n("once");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.transmitter != null) {
            tagCompound.func_74768_a("transX", this.transmitter.getCoordinate().func_177958_n());
            tagCompound.func_74768_a("transY", this.transmitter.getCoordinate().func_177956_o());
            tagCompound.func_74768_a("transZ", this.transmitter.getCoordinate().func_177952_p());
            tagCompound.func_74768_a("transDim", this.transmitter.getDimension());
        }
        if (this.receiver != null) {
            tagCompound.func_74768_a("receiver", this.receiver.intValue());
        }
        tagCompound.func_74757_a("once", this.onceMode);
    }
}

