/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.ThreadFileDownloader;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;

public class FileDownloadManager
implements Runnable {
    public volatile int totalFiles = 0;
    public volatile int filesDownloaded = 0;
    public volatile boolean running = false;
    public volatile boolean downloadsComplete = false;
    public Map<String, File> failedFiles = Collections.synchronizedMap(new HashMap());
    private String name;
    private boolean resetOnFinish;
    private Runnable queCompeteCallback = null;
    private final ThreadFileDownloader[] workers;
    private volatile boolean stopDownload = false;
    private Queue<PairKV<String, File>> downloadQue = new ConcurrentLinkedDeque<PairKV<String, File>>();

    public FileDownloadManager(String name, int maxWorkers, boolean resetOnFinish) {
        this.name = name;
        this.workers = new ThreadFileDownloader[maxWorkers];
        this.resetOnFinish = resetOnFinish;
    }

    public void startDownload() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.downloadsComplete = false;
        new Thread((Runnable)this, this.name).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (!this.downloadsComplete) {
            int i;
            ThreadFileDownloader[] threadFileDownloaderArray = this.workers;
            // MONITORENTER : this.workers
            if (this.stopDownload) {
                for (i = 0; i < this.workers.length; ++i) {
                    if (this.workers[i].isRunning()) continue;
                    this.workers[i].interrupt();
                    this.downloadQue.add(new PairKV<String, File>(this.workers[i].sourceURL, this.workers[i].outputFile));
                    this.workers[i] = null;
                }
                this.stopDownload = false;
                // MONITOREXIT : threadFileDownloaderArray
                break;
            }
            this.downloadsComplete = this.downloadQue.isEmpty();
            for (i = 0; i < this.workers.length; ++i) {
                ThreadFileDownloader worker = this.workers[i];
                if (worker != null && worker.downloadFailed()) {
                    this.failedFiles.put(worker.sourceURL, worker.outputFile);
                }
                if (worker != null && worker.isRunning()) {
                    this.downloadsComplete = false;
                    continue;
                }
                if (this.downloadQue.size() <= 0) continue;
                ++this.filesDownloaded;
                PairKV<String, File> file = this.downloadQue.poll();
                worker = new ThreadFileDownloader(this.name + ":worker-" + i, file.getKey(), file.getValue());
                LogHelperBC.dev("FileDownloadHandler: Starting Download: " + file.getKey() + " -> " + file.getValue());
                this.workers[i] = worker;
                worker.start();
            }
            // MONITOREXIT : threadFileDownloaderArray
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.running = false;
        if (this.queCompeteCallback != null) {
            this.queCompeteCallback.run();
        }
        if (!this.resetOnFinish) return;
        this.reset();
    }

    public boolean addFileToQue(String url, File file, boolean startIfStopped) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        this.downloadQue.add(new PairKV<String, File>(url, file));
        if (startIfStopped) {
            this.startDownload();
        }
        ++this.totalFiles;
        return this.running;
    }

    public void addFileToQue(String url, File file) {
        this.addFileToQue(url, file, true);
    }

    public void stopDownloads() {
        this.stopDownload = true;
    }

    public void reset() {
        if (this.running) {
            return;
        }
        this.totalFiles = 0;
        this.filesDownloaded = 0;
        this.failedFiles.clear();
        this.downloadQue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, Double> getActiveProgress() {
        HashMap<File, Double> map = new HashMap<File, Double>();
        ThreadFileDownloader[] threadFileDownloaderArray = this.workers;
        synchronized (this.workers) {
            for (ThreadFileDownloader thread : this.workers) {
                if (thread == null || !thread.isRunning()) continue;
                map.put(thread.outputFile, thread.getProgress());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    public double getDownloadProgressTotal() {
        double total = this.filesDownloaded;
        for (Double d : this.getActiveProgress().values()) {
            total += d.doubleValue();
        }
        return total / (double)this.totalFiles;
    }

    public void setQueCompeteCallback(Runnable queCompeteCallback) {
        this.queCompeteCallback = queCompeteCallback;
    }
}

