/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.items;

import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.items.chest.ItemChestChanger;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public enum ChestChangerType {
    IRON_GOLD(IronChestType.IRON, IronChestType.GOLD, "iron_gold_chest_upgrade"),
    GOLD_DIAMOND(IronChestType.GOLD, IronChestType.DIAMOND, "gold_diamond_chest_upgrade"),
    COPPER_SILVER(IronChestType.COPPER, IronChestType.SILVER, "copper_silver_chest_upgrade"),
    SILVER_GOLD(IronChestType.SILVER, IronChestType.GOLD, "silver_gold_chest_upgrade"),
    COPPER_IRON(IronChestType.COPPER, IronChestType.IRON, "copper_iron_chest_upgrade"),
    DIAMOND_CRYSTAL(IronChestType.DIAMOND, IronChestType.CRYSTAL, "diamond_crystal_chest_upgrade"),
    WOOD_IRON(IronChestType.WOOD, IronChestType.IRON, "wood_iron_chest_upgrade"),
    WOOD_COPPER(IronChestType.WOOD, IronChestType.COPPER, "wood_copper_chest_upgrade"),
    DIAMOND_OBSIDIAN(IronChestType.DIAMOND, IronChestType.OBSIDIAN, "diamond_obsidian_chest_upgrade");

    public static final ChestChangerType[] VALUES;
    public final IronChestType source;
    public final IronChestType target;
    public final String itemName;
    public ItemChestChanger item;

    private ChestChangerType(IronChestType source, IronChestType target, String itemName) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public ItemChestChanger buildItem(IForgeRegistry<Item> itemRegistry) {
        this.item = new ItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        itemRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public static void buildItems(IForgeRegistry<Item> itemRegistry) {
        for (ChestChangerType type : VALUES) {
            type.buildItem(itemRegistry);
        }
    }

    static {
        VALUES = ChestChangerType.values();
    }
}

