/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.item.ItemSatellite;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;

public class SatelliteRegistry {
    static HashMap<String, Class<? extends SatelliteBase>> registry = new HashMap();
    static HashMap<ItemStack, SatelliteProperties> itemPropertiesRegistry = new HashMap();

    public static void registerSatelliteProperty(@Nonnull ItemStack stack, SatelliteProperties properties) {
        if (stack.func_190926_b()) {
            Logger.getLogger("advancedrocketry").warning("Empty satellite property being registered!");
        } else if (!itemPropertiesRegistry.containsKey(stack)) {
            itemPropertiesRegistry.put(stack, properties);
        } else {
            Logger.getLogger("advancedrocketry").warning("Duplicate satellite property being registered for " + stack);
        }
    }

    public static SatelliteProperties getSatelliteProperty(@Nonnull ItemStack stack) {
        for (ItemStack keyStack : itemPropertiesRegistry.keySet()) {
            if (keyStack.func_77973_b() != stack.func_77973_b() || keyStack.func_77981_g() && keyStack.func_77952_i() != stack.func_77952_i()) continue;
            return itemPropertiesRegistry.get(keyStack);
        }
        return null;
    }

    public static void registerSatellite(String name, Class<? extends SatelliteBase> clazz) {
        registry.put(name, clazz);
    }

    public static String getKey(Class<? extends SatelliteBase> clazz) {
        for (Map.Entry<String, Class<? extends SatelliteBase>> entrySet : registry.entrySet()) {
            if (entrySet.getValue() != clazz) continue;
            return entrySet.getKey();
        }
        return "poo";
    }

    public static SatelliteBase createFromNBT(NBTTagCompound nbt) {
        SatelliteBase satellite = SatelliteRegistry.getNewSatellite(nbt.func_74779_i("dataType"));
        satellite.readFromNBT(nbt);
        return satellite;
    }

    public static SatelliteBase getNewSatellite(String name) {
        Class<? extends SatelliteBase> clazz = registry.get(name);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getSatelliteId(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()) != null) {
            if (stack.func_77973_b() instanceof ItemSatelliteIdentificationChip) {
                return nbt.func_74763_f("satelliteId");
            }
            return nbt.func_74763_f("satId");
        }
        return -1L;
    }

    public static SatelliteBase getSatellite(@Nonnull ItemStack stack) {
        if (SatelliteRegistry.getSatelliteId(stack) != -1L) {
            return DimensionManager.getInstance().getSatellite(SatelliteRegistry.getSatelliteId(stack));
        }
        return null;
    }

    public static SatelliteProperties getSatelliteProperties(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (SatelliteRegistry.getSatelliteId(stack) != -1L && (nbt = stack.func_77978_p()) != null && stack.func_77973_b() instanceof ItemSatellite) {
            SatelliteProperties properties = new SatelliteProperties(nbt.func_74762_e("powerGeneration"), nbt.func_74762_e("powerStorage"), nbt.func_74779_i("dataType"), nbt.func_74762_e("maxData"));
            properties.setId(SatelliteRegistry.getSatelliteId(stack));
            return properties;
        }
        return null;
    }
}

