/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.dimension.solar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.util.SpacePosition;

public class StellarBody {
    private int temperature;
    private HashMap<Integer, IDimensionProperties> planets = new HashMap();
    int numPlanets;
    int discoveredPlanets;
    float[] color;
    int id;
    float size = 1.0f;
    String name;
    short posX;
    short posZ;
    public List<StellarBody> subStars = new LinkedList<StellarBody>();
    float starSeperation = 5.0f;
    private boolean isBlackHole = false;
    StellarBody parentStar;

    public List<StellarBody> getSubStars() {
        return this.subStars;
    }

    public void addSubStar(StellarBody star) {
        if (star.name == null) {
            star.setName(this.name + "-" + (this.subStars.size() + 1));
        }
        star.setId(this.id);
        this.subStars.add(star);
        star.parentStar = this;
    }

    public boolean isBlackHole() {
        return this.isBlackHole;
    }

    public void setBlackHole(boolean isBlackHole) {
        this.isBlackHole = isBlackHole;
    }

    public int getDisplayRadius() {
        return (int)(100.0f * this.size);
    }

    public float getStarSeparation() {
        return this.starSeperation;
    }

    public void setStarSeparation(float seperation) {
        this.starSeperation = seperation;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setPosX(int x) {
        this.posX = (short)x;
    }

    public void setPosZ(int x) {
        this.posZ = (short)x;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
        this.color = this.getColor();
    }

    public void addPlanet(IDimensionProperties planet) {
        if (!this.planets.containsKey(planet.getId())) {
            ++this.numPlanets;
        }
        this.planets.put(planet.getId(), planet);
    }

    public IDimensionProperties removePlanet(IDimensionProperties planet) {
        --this.numPlanets;
        return this.planets.remove(planet.getId());
    }

    public int getNumPlanets() {
        if (this.parentStar != null) {
            return this.parentStar.getNumPlanets();
        }
        return this.numPlanets;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getColorRGB8() {
        if (this.color == null) {
            this.color = this.getColor();
        }
        return (int)(this.color[0] * 255.0f) | (int)(this.color[1] * 255.0f) << 8 | (int)(this.color[2] * 255.0f) << 16;
    }

    public float[] getColor() {
        float[] color = new float[3];
        float temperature = (float)this.getTemperature() * 0.477f + 10.0f;
        if (temperature < 66.0f) {
            color[0] = 1.0f;
        } else {
            color[0] = temperature - 60.0f;
            color[0] = 329.69f * (float)Math.pow(color[0], -0.1332f);
            color[0] = MathHelper.func_76131_a((float)(color[0] / 255.0f), (float)0.0f, (float)1.0f);
        }
        if (temperature < 66.0f) {
            color[1] = temperature;
            color[1] = (float)((double)99.47f * Math.log(color[1]) - (double)161.1f);
        } else {
            color[1] = temperature - 60.0f;
            color[1] = 288.0f * (float)Math.pow(color[1], -0.07551);
        }
        color[1] = MathHelper.func_76131_a((float)(color[1] / 255.0f), (float)0.0f, (float)1.0f);
        if (temperature > 67.0f) {
            color[2] = 1.0f;
        } else if (temperature <= 19.0f) {
            color[2] = 0.0f;
        } else {
            color[2] = temperature - 10.0f;
            color[2] = (float)((double)138.51f * Math.log(color[2]) - (double)305.04f);
            color[2] = MathHelper.func_76131_a((float)(color[2] / 255.0f), (float)0.0f, (float)1.0f);
        }
        return color;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String str) {
        this.name = str;
    }

    public List<IDimensionProperties> getPlanets() {
        return new ArrayList<IDimensionProperties>(this.planets.values());
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("id", this.id);
        nbt.func_74768_a("temperature", this.temperature);
        nbt.func_74778_a("name", this.name);
        nbt.func_74777_a("posX", this.posX);
        nbt.func_74777_a("posZ", this.posZ);
        nbt.func_74776_a("size", this.size);
        nbt.func_74776_a("seperation", this.starSeperation);
        nbt.func_74757_a("isBlackHole", this.isBlackHole);
        NBTTagList list = new NBTTagList();
        for (StellarBody body : this.subStars) {
            NBTTagCompound tag = new NBTTagCompound();
            body.writeToNBT(tag);
            list.func_74742_a((NBTBase)tag);
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a("subStars", (NBTBase)list);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.id = nbt.func_74762_e("id");
        this.temperature = nbt.func_74762_e("temperature");
        this.name = nbt.func_74779_i("name");
        this.posX = nbt.func_74765_d("posX");
        this.posZ = nbt.func_74765_d("posZ");
        this.isBlackHole = nbt.func_74767_n("isBlackHole");
        if (nbt.func_74764_b("size")) {
            this.size = nbt.func_74760_g("size");
        }
        if (nbt.func_74764_b("seperation")) {
            this.starSeperation = nbt.func_74760_g("seperation");
        }
        this.subStars.clear();
        if (nbt.func_74764_b("subStars")) {
            NBTTagList list = nbt.func_150295_c("subStars", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                StellarBody star = new StellarBody();
                star.readFromNBT(list.func_150305_b(i));
                this.subStars.add(star);
                star.parentStar = this;
            }
        }
    }

    public SpacePosition getSpacePosition() {
        return new SpacePosition();
    }
}

