/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.tile.cables.TilePipe;

public class CableTickHandler {
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent tick) {
        try {
            if (tick.phase == TickEvent.Phase.END) {
                NetworkRegistry.dataNetwork.tickAllNetworks();
                NetworkRegistry.energyNetwork.tickAllNetworks();
                NetworkRegistry.liquidNetwork.tickAllNetworks();
            }
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void chunkLoadedEvent(ChunkEvent.Load event) {
        Map map = event.getChunk().func_177434_r();
        Iterator iter = map.entrySet().iterator();
        try {
            while (iter.hasNext()) {
                Object obj = iter.next().getValue();
                if (!(obj instanceof TilePipe)) continue;
                ((TilePipe)((Object)obj)).func_70296_d();
            }
        }
        catch (ConcurrentModificationException e) {
            AdvancedRocketry.logger.warn("You have been visited by the rare pepe.. I mean error of pipes not loading, this is not good, some pipe systems may not work right away.  But it's better than a corrupt world");
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c().hasTileEntity(event.getState())) {
            TileEntity homeTile = event.getWorld().func_175625_s(event.getPos());
            if (homeTile instanceof TilePipe) {
                TileEntity tile;
                ((TilePipe)homeTile).setDestroyed();
                ((TilePipe)homeTile).setInvalid();
                int pipecount = 0;
                for (EnumFacing dir : EnumFacing.values()) {
                    tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                    if (!(tile instanceof TilePipe)) continue;
                    ++pipecount;
                }
                if (pipecount > 1) {
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                        if (!(tile instanceof TilePipe)) continue;
                        ((TilePipe)tile).getNetworkHandler().removeNetworkByID(((TilePipe)tile).getNetworkID());
                        ((TilePipe)tile).setInvalid();
                    }
                }
                if (pipecount == 0) {
                    ((TilePipe)homeTile).getNetworkHandler().removeNetworkByID(((TilePipe)homeTile).getNetworkID());
                }
                homeTile.func_70296_d();
            } else if (homeTile != null) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity tile = event.getWorld().func_175625_s(event.getPos().func_177972_a(dir));
                    if (!(tile instanceof TilePipe)) continue;
                    ((TilePipe)tile).getNetworkHandler().removeFromAllTypes((TilePipe)tile, homeTile);
                }
            }
        }
    }
}

