/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.provider;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.render.planet.RenderSpaceSky;
import zmaster587.advancedRocketry.client.render.planet.RenderSpaceTravelSky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.stations.SpaceStationObject;
import zmaster587.advancedRocketry.util.AstronomicalBodyHelper;
import zmaster587.advancedRocketry.world.ChunkProviderSpace;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;

public class WorldProviderSpace
extends WorldProviderPlanet {
    private IRenderHandler skyRender;

    @Override
    public double getHorizon() {
        return 0.0;
    }

    @Override
    public boolean isPlanet() {
        return false;
    }

    public int func_76557_i() {
        return 0;
    }

    @Override
    public IChunkGenerator func_186060_c() {
        return new ChunkProviderSpace(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        Entity e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (e = player.func_184187_bx()) instanceof EntityRocket && ((EntityRocket)e).getInSpaceFlight()) {
            if (!(this.skyRender instanceof RenderSpaceTravelSky)) {
                this.skyRender = new RenderSpaceTravelSky();
            }
            return this.skyRender;
        }
        if (ARConfiguration.getCurrentConfig().stationSkyOverride) {
            RenderSpaceSky renderSpaceSky;
            if (this.skyRender == null || !(this.skyRender instanceof RenderSpaceSky)) {
                this.skyRender = new RenderSpaceSky();
                renderSpaceSky = this.skyRender;
            } else {
                renderSpaceSky = this.skyRender;
            }
            return renderSpaceSky;
        }
        return super.getSkyRenderer();
    }

    @Override
    public float getAtmosphereDensity(BlockPos pos) {
        return 0.0f;
    }

    @Override
    public float func_76563_a(long worldTime, float p_76563_3_) {
        return AdvancedRocketry.proxy.calculateCelestialAngleSpaceStation();
    }

    @Override
    public float getSunBrightness(float partialTicks) {
        DimensionProperties properties = this.getDimensionProperties(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        SpaceStationObject spaceStation = (SpaceStationObject)this.getSpaceObject(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        if (spaceStation != null) {
            float preWarpBrightnessMultiplier = (float)AstronomicalBodyHelper.getPlanetaryLightLevelMultiplier(AstronomicalBodyHelper.getStellarBrightness(properties.getStar(), properties.getSolarOrbitalDistance()));
            return spaceStation.isWarping() ? 0.0f : preWarpBrightnessMultiplier * this.field_76579_a.getSunBrightnessBody(partialTicks);
        }
        return 0.0f;
    }

    @Override
    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76579_a.func_72912_H().func_76085_a(AdvancedRocketry.spaceWorldType);
        this.field_76578_c = new BiomeProviderSingle(AdvancedRocketryBiomes.spaceBiome);
    }

    public ISpaceObject getSpaceObject(BlockPos pos) {
        return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos);
    }

    @Override
    public DimensionProperties getDimensionProperties(BlockPos pos) {
        ISpaceObject spaceObject = this.getSpaceObject(pos);
        if (spaceObject != null) {
            return (DimensionProperties)spaceObject.getProperties();
        }
        return DimensionManager.defaultSpaceDimensionProperties;
    }
}

