/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.HeatExtractionTracker;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourLiquid;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class HeatBehaviourTransition
extends HeatBehaviourLiquid {
    private double maxExchangedHeat;
    private double blockTemp = -1.0;
    private IHeatExchangerLogic logic;
    private HeatExtractionTracker tracker;

    @Override
    public boolean isApplicable() {
        this.logic = HeatExchangerManager.getInstance().getLogic(this.getWorld(), this.getPos(), null);
        return this.logic != null;
    }

    @Override
    public void initialize(String id, IHeatExchangerLogic connectedHeatLogic, World world, BlockPos pos, EnumFacing direction) {
        super.initialize(id, connectedHeatLogic, world, pos, direction);
        this.tracker = HeatExtractionTracker.getInstance(this.getWorld());
    }

    protected abstract int getMaxExchangedHeat();

    protected boolean transformBlockHot() {
        return false;
    }

    protected boolean transformBlockCold() {
        return false;
    }

    @Override
    public void update() {
        double extractedHeat;
        if (this.blockTemp == -1.0) {
            this.blockTemp = this.logic.getTemperature();
            this.maxExchangedHeat = (double)this.getMaxExchangedHeat() * (this.logic.getThermalResistance() + this.getHeatExchanger().getThermalResistance());
        }
        if ((extractedHeat = this.tracker.getHeatExtracted(this.getPos())) < Math.abs(this.maxExchangedHeat)) {
            double toExtract = this.blockTemp - this.getHeatExchanger().getTemperature();
            this.tracker.extractHeat(this.getPos(), toExtract);
            extractedHeat += toExtract;
        }
        if (extractedHeat >= this.maxExchangedHeat) {
            if (this.transformBlockCold()) {
                this.tracker.extractHeat(this.getPos(), -this.maxExchangedHeat);
            }
        } else if (extractedHeat <= -this.maxExchangedHeat && this.transformBlockHot()) {
            this.tracker.extractHeat(this.getPos(), this.maxExchangedHeat);
        }
    }

    void onTransition(BlockPos pos) {
        NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187541_bC, SoundCategory.AMBIENT, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.5f, 2.6f + (this.getWorld().field_73012_v.nextFloat() - this.getWorld().field_73012_v.nextFloat()) * 0.8f, true), this.getWorld());
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, 8, 1.0, 0.0, 1.0), this.getWorld());
    }
}

