/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.entity.living.EntityBasicDrone;
import me.desht.pneumaticcraft.common.item.ItemDrone;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemBasicDrone
extends ItemDrone {
    private final BiFunction<World, EntityPlayer, EntityBasicDrone> droneCreator;

    public ItemBasicDrone(String name, BiFunction<World, EntityPlayer, EntityBasicDrone> droneCreator) {
        super(name);
        this.droneCreator = droneCreator;
        this.func_77625_d(64);
    }

    @Override
    public void spawnDrone(EntityPlayer player, World world, BlockPos clickPos, EnumFacing facing, BlockPos placePos, ItemStack iStack) {
        EntityBasicDrone drone = this.droneCreator.apply(world, player);
        drone.func_70107_b((double)placePos.func_177958_n() + 0.5, (double)placePos.func_177956_o() + 0.5, (double)placePos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)drone);
        NBTTagCompound stackTag = iStack.func_77978_p();
        NBTTagCompound entityTag = new NBTTagCompound();
        drone.func_70014_b(entityTag);
        if (stackTag != null) {
            entityTag.func_74776_a("currentAir", stackTag.func_74760_g("currentAir"));
            entityTag.func_74768_a("color", stackTag.func_74762_e("color"));
            entityTag.func_74782_a("UpgradeInventory", (NBTBase)stackTag.func_74775_l("UpgradeInventory"));
        }
        drone.func_70037_a(entityTag);
        drone.addProgram(clickPos, facing, placePos, drone.progWidgets);
        TileEntityProgrammer.updatePuzzleConnections(drone.progWidgets);
        if (iStack.func_82837_s()) {
            drone.func_96094_a(iStack.func_82833_r());
        }
        drone.naturallySpawned = false;
        drone.func_180482_a(world.func_175649_E(placePos), null);
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return false;
    }

    @Override
    public boolean upgradeApplies(IItemRegistry.EnumUpgrade upgrade) {
        switch (upgrade) {
            case VOLUME: 
            case ITEM_LIFE: 
            case SECURITY: 
            case SPEED: 
            case MAGNET: {
                return true;
            }
        }
        return false;
    }
}

