/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.igwmod;

import igwmod.TextureSupplier;
import igwmod.api.IRecipeIntegrator;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import igwmod.gui.LocatedEntity;
import igwmod.gui.LocatedStack;
import igwmod.gui.LocatedString;
import igwmod.gui.LocatedTexture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.thirdparty.igwmod.IGWHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class IntegratorPressureChamber
implements IRecipeIntegrator {
    public String getCommandKey() {
        return "pressureChamber";
    }

    public void onCommandInvoke(String[] arguments, List<IReservedSpace> reservedSpaces, List<LocatedString> locatedStrings, List<LocatedStack> locatedStacks, List<IWidget> locatedTextures) throws IllegalArgumentException {
        int y;
        int x;
        if (arguments.length != 3) {
            throw new IllegalArgumentException("Code needs 3 arguments!");
        }
        try {
            x = Integer.parseInt(arguments[0]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The first parameter (the x coordinate) contains an invalid number. Check for invalid characters!");
        }
        try {
            y = Integer.parseInt(arguments[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The second parameter (the y coordinate) contains an invalid number. Check for invalid characters!");
        }
        locatedTextures.add((IWidget)new LocatedTexture(TextureSupplier.getTexture((String)"pneumaticcraft:textures/wiki/pressure_chamber_recipe.png"), x, y, 2.0));
        switch (arguments[2]) {
            case "disenchanting": {
                this.handleDisenchanting(x, y, locatedStacks);
                break;
            }
            case "villagers": {
                this.handleVillagers(x, y, locatedTextures);
                break;
            }
            default: {
                LocatedStack stack;
                int i;
                IPressureChamberRecipe foundRecipe = null;
                block12: for (IPressureChamberRecipe recipe : PressureChamberRecipe.recipes) {
                    for (ItemStack output : recipe.getResult()) {
                        if (!IGWHandler.getNameFromStack(output).equals(arguments[2])) continue;
                        foundRecipe = recipe;
                        continue block12;
                    }
                }
                if (foundRecipe == null) {
                    throw new IllegalArgumentException("No recipe found for the key " + arguments[2]);
                }
                locatedStrings.add(new LocatedString(I18n.func_135052_a((String)"igwmod.pressureChamber.requiredPressure", (Object[])new Object[0]) + ":", x + 180, y + 10, -16777216, false));
                locatedStrings.add(new LocatedString(foundRecipe.getCraftingPressure() + " bar", x + 215, y + 20, -16777216, false));
                for (i = 0; i < foundRecipe.getInput().size(); ++i) {
                    stack = new LocatedStack(foundRecipe.getInput().get(i).getSingleStack(), (int)((double)(x + 36 + i % 3 * 34) * 0.5), (int)((double)(y + 102 - i / 3 * 34) * 0.5));
                    locatedStacks.add(stack);
                }
                for (i = 0; i < foundRecipe.getResult().size(); ++i) {
                    stack = new LocatedStack((ItemStack)foundRecipe.getResult().get(i), (int)((double)(x + 180 + i % 3 * 36) * 0.5), (int)((double)(y + 60 + i / 3 * 36) * 0.5));
                    locatedStacks.add(stack);
                }
            }
        }
    }

    private void handleVillagers(int x, int y, List<IWidget> locatedTextures) {
        locatedTextures.add((IWidget)new LocatedEntity(EntityVillager.class, x + 70, y + 95, 2.0f));
        LocatedEntity locatedEntity = new LocatedEntity(EntityVillager.class, x + 215, y + 125, 2.0f);
        EntityVillager villager = (EntityVillager)locatedEntity.entity;
        locatedTextures.add((IWidget)locatedEntity);
    }

    private void handleDisenchanting(int x, int y, List<LocatedStack> locatedStacks) {
        LocatedStack stack;
        int i;
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        ItemStack enchantedItem = new ItemStack(Items.field_151048_u);
        EnchantmentHelper.func_77504_a((Random)new Random(), (ItemStack)enchantedItem, (int)30, (boolean)true);
        input.add(enchantedItem);
        output.add(new ItemStack(Items.field_151048_u));
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)enchantedItem);
        for (Map.Entry enchant : enchants.entrySet()) {
            ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
            HashMap newMap = new HashMap();
            newMap.put(enchant.getKey(), enchant.getValue());
            EnchantmentHelper.func_82782_a(newMap, (ItemStack)enchantedBook);
            output.add(enchantedBook);
            input.add(new ItemStack(Items.field_151122_aG));
        }
        for (i = 0; i < input.size(); ++i) {
            stack = new LocatedStack((ItemStack)input.get(i), (int)((double)(x + 36 + i % 3 * 34) * 0.5), (int)((double)(y + 102 - i / 3 * 34) * 0.5));
            locatedStacks.add(stack);
        }
        for (i = 0; i < output.size(); ++i) {
            stack = new LocatedStack((ItemStack)output.get(i), (int)((double)(x + 180 + i % 3 * 36) * 0.5), (int)((double)(y + 60 + i / 3 * 36) * 0.5));
            locatedStacks.add(stack);
        }
    }
}

