/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.PlasticMixerRegistry;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControlled;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISmartFluidSync;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.DyeUtils;
import org.apache.commons.lang3.Validate;

public class TileEntityPlasticMixer
extends TileEntityTickableBase
implements IHeatExchanger,
IRedstoneControlled,
ISerializableTanks,
ISmartFluidSync {
    private static final List<String> REDSTONE_LABELS = ImmutableList.of((Object)"gui.tab.redstoneBehaviour.button.anySignal", (Object)"gui.tab.redstoneBehaviour.button.highSignal", (Object)"gui.tab.redstoneBehaviour.button.lowSignal", (Object)"gui.tab.redstoneBehaviour.plasticMixer.button.selectOnSignal");
    public static final int INVENTORY_SIZE = 5;
    public static final int DYE_BUFFER_MAX = 8160;
    private static final int DYE_PER_DYE = 2550;
    public static final int INV_INPUT = 0;
    public static final int INV_OUTPUT = 1;
    public static final int INV_DYE_RED = 2;
    public static final int INV_DYE_GREEN = 3;
    public static final int INV_DYE_BLUE = 4;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final PlasticFluidTank tank = new PlasticFluidTank(16000);
    @DescSynced
    private int fluidAmountScaled;
    private final ItemStackHandler inventory = new PlasticItemStackHandler();
    private final IItemHandlerModifiable inventoryPublic = new PlasticItemStackHandlerPublic();
    private int lastTickInventoryStacksize;
    @GuiSynced
    private final IHeatExchangerLogic hullHeatLogic = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    private final IHeatExchangerLogic itemHeatLogic = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    @GuiSynced
    public int selectedPlastic = -1;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    public boolean lockSelection;
    @GuiSynced
    public final int[] dyeBuffers = new int[3];

    public TileEntityPlasticMixer() {
        super(4);
        this.hullHeatLogic.addConnectedExchanger(this.itemHeatLogic);
        this.hullHeatLogic.setThermalCapacity(100.0);
    }

    @SideOnly(value=Side.CLIENT)
    public IHeatExchangerLogic getLogic(int index) {
        switch (index) {
            case 0: {
                return this.hullHeatLogic;
            }
            case 1: {
                return this.itemHeatLogic;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + index);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public String getName() {
        return Blockss.PLASTIC_MIXER.func_149739_a();
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        this.itemHeatLogic.initializeAmbientTemperature(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.refillDyeBuffers();
            this.itemHeatLogic.update();
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            if (this.func_145831_w().func_82737_E() % 20L == 0L) {
                if (inputStack.func_190916_E() > this.lastTickInventoryStacksize) {
                    int stackIncrease = inputStack.func_190916_E() - this.lastTickInventoryStacksize;
                    double heatingRatio = (double)inputStack.func_190916_E() / (double)(inputStack.func_190916_E() + stackIncrease);
                    this.itemHeatLogic.setTemperature((int)(heatingRatio * this.itemHeatLogic.getTemperature() + (1.0 - heatingRatio) * this.hullHeatLogic.getAmbientTemperature()));
                }
                if (!inputStack.func_190926_b()) {
                    this.tryMeltPlastic(inputStack);
                }
                this.lastTickInventoryStacksize = this.inventory.getStackInSlot(0).func_190916_E();
                this.itemHeatLogic.setThermalCapacity(this.lastTickInventoryStacksize);
            }
            if (this.tank.getFluid() != null && this.selectedPlastic >= 0 && this.redstoneAllows()) {
                this.trySolidifyPlastic();
            }
            if (!this.lockSelection) {
                this.selectedPlastic = -1;
            }
            if (this.redstoneMode == 3) {
                this.selectedPlastic = this.poweredRedstone;
            }
        }
    }

    private void tryMeltPlastic(ItemStack inputStack) {
        FluidStack moltenPlastic;
        int filled;
        PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(inputStack);
        if (recipe != null && recipe.allowMelting() && this.itemHeatLogic.getTemperature() >= (double)recipe.getTemperature() && (filled = this.tank.fill(moltenPlastic = recipe.getFluidStack().copy(), false)) == moltenPlastic.amount) {
            this.inventory.extractItem(0, 1, false);
            this.tank.fill(moltenPlastic, true);
            this.itemHeatLogic.addHeat(-1.0);
        }
    }

    private void trySolidifyPlastic() {
        PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(this.tank.getFluid());
        if (recipe != null && recipe.allowSolidifying() && (recipe.getMeta() < 0 || recipe.getMeta() == this.selectedPlastic)) {
            ItemStack solidifiedStack = ItemHandlerHelper.copyStackWithSize((ItemStack)recipe.getItemStack(), (int)1);
            solidifiedStack.func_77964_b(this.selectedPlastic);
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                solidifiedStack.func_190920_e(recipe.useDye() ? this.useDye(solidifiedStack.func_190916_E()) : solidifiedStack.func_190916_E());
                if (solidifiedStack.func_190916_E() > 0) {
                    this.inventory.setStackInSlot(1, solidifiedStack);
                    this.tank.drain(solidifiedStack.func_190916_E() * recipe.getFluidStack().amount, true);
                }
            } else if (solidifiedStack.func_77969_a(this.inventory.getStackInSlot(1))) {
                int solidifiedItems = Math.min(solidifiedStack.func_77976_d() - this.inventory.getStackInSlot(1).func_190916_E(), solidifiedStack.func_190916_E());
                if (recipe.useDye()) {
                    solidifiedItems = this.useDye(solidifiedItems);
                }
                ItemStack newStack = this.inventory.getStackInSlot(1);
                newStack.func_190917_f(solidifiedItems);
                this.tank.drain(solidifiedItems * recipe.getFluidStack().amount, true);
            }
        }
    }

    private void refillDyeBuffers() {
        for (int i = 0; i < 3; ++i) {
            if (this.inventory.getStackInSlot(2 + i).func_190926_b() || this.dyeBuffers[i] > 5610) continue;
            this.inventory.extractItem(2 + i, 1, false);
            int n = i;
            this.dyeBuffers[n] = this.dyeBuffers[n] + 2550;
        }
    }

    private int useDye(int maxItems) {
        int colorComponent;
        int i;
        if (this.selectedPlastic == EnumDyeColor.WHITE.func_176767_b()) {
            return maxItems;
        }
        int desiredColor = ItemDye.field_150922_c[this.selectedPlastic];
        for (i = 0; i < 3; ++i) {
            colorComponent = desiredColor >> 8 * i & 0xFF;
            if ((colorComponent = 255 - colorComponent) <= 0) continue;
            maxItems = Math.min(maxItems, this.dyeBuffers[i] / colorComponent);
        }
        if (maxItems > 0) {
            i = 0;
            while (i < 3) {
                colorComponent = desiredColor >> 8 * i & 0xFF;
                colorComponent = 255 - colorComponent;
                int n = i++;
                this.dyeBuffers[n] = this.dyeBuffers[n] - colorComponent * maxItems;
            }
        }
        return maxItems;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.lastTickInventoryStacksize = tag.func_74762_e("lastTickInventoryStacksize");
        this.selectedPlastic = tag.func_74762_e("selectedPlastic");
        this.lockSelection = tag.func_74767_n("lockSelection");
        this.dyeBuffers[0] = tag.func_74762_e("dyeBuffer0");
        this.dyeBuffers[1] = tag.func_74762_e("dyeBuffer1");
        this.dyeBuffers[2] = tag.func_74762_e("dyeBuffer2");
        this.redstoneMode = tag.func_74762_e("redstoneMode");
        this.itemHeatLogic.readFromNBT(tag.func_74775_l("itemLogic"));
        this.tank.setFluid(null);
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.fluidAmountScaled = this.tank.getScaledFluidAmount();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("lastTickInventoryStacksize", this.lastTickInventoryStacksize);
        tag.func_74768_a("selectedPlastic", this.selectedPlastic);
        tag.func_74757_a("lockSelection", this.lockSelection);
        tag.func_74768_a("dyeBuffer0", this.dyeBuffers[0]);
        tag.func_74768_a("dyeBuffer1", this.dyeBuffers[1]);
        tag.func_74768_a("dyeBuffer2", this.dyeBuffers[2]);
        tag.func_74768_a("redstoneMode", this.redstoneMode);
        NBTTagCompound heatTag = new NBTTagCompound();
        this.itemHeatLogic.writeToNBT(heatTag);
        tag.func_74782_a("itemLogic", (NBTBase)heatTag);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("fluid", (NBTBase)tankTag);
        return tag;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Override
    public void updateScaledFluidAmount(int tankIndex, int amount) {
        this.fluidAmountScaled = amount;
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        return this.hullHeatLogic;
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        super.handleGUIButtonPress(guiID, player);
        if (guiID == 0) {
            if (++this.redstoneMode > 3) {
                this.redstoneMode = 0;
            }
        } else if (guiID >= 1 && guiID < 17) {
            this.selectedPlastic = this.selectedPlastic != guiID ? guiID - 1 : -1;
        } else if (guiID == 17) {
            this.lockSelection = !this.lockSelection;
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryPublic);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public boolean redstoneAllows() {
        return this.redstoneMode == 3 || super.redstoneAllows();
    }

    @Override
    protected void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("selectColor"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "color_index (0-16)");
                int selection = ((Double)args[0]).intValue();
                Validate.isTrue((selection >= 0 && selection <= 16 ? 1 : 0) != 0, (String)("color index " + selection + " out of range 0-16!"), (Object[])new Object[0]);
                TileEntityPlasticMixer.this.selectedPlastic = selection - 1;
                return null;
            }
        });
    }

    @Override
    protected List<String> getRedstoneButtonLabels() {
        return REDSTONE_LABELS;
    }

    private class PlasticItemStackHandlerPublic
    implements IItemHandlerModifiable {
        private PlasticItemStackHandlerPublic() {
        }

        public int getSlots() {
            return 5;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return TileEntityPlasticMixer.this.inventory.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 1 ? stack : TileEntityPlasticMixer.this.inventory.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? TileEntityPlasticMixer.this.inventory.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return TileEntityPlasticMixer.this.inventory.getSlotLimit(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            TileEntityPlasticMixer.this.inventory.setStackInSlot(slot, stack);
        }
    }

    private class PlasticItemStackHandler
    extends BaseItemStackHandler {
        PlasticItemStackHandler() {
            super(TileEntityPlasticMixer.this, 5);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (stack.func_190926_b()) {
                return true;
            }
            switch (slot) {
                case 0: {
                    return PlasticMixerRegistry.INSTANCE.isValidInputItem(stack);
                }
                case 1: {
                    return PlasticMixerRegistry.INSTANCE.isValidOutputItem(stack);
                }
                case 2: {
                    return DyeUtils.rawDyeDamageFromStack((ItemStack)stack) == EnumDyeColor.RED.func_176767_b();
                }
                case 3: {
                    return DyeUtils.rawDyeDamageFromStack((ItemStack)stack) == EnumDyeColor.GREEN.func_176767_b();
                }
                case 4: {
                    return DyeUtils.rawDyeDamageFromStack((ItemStack)stack) == EnumDyeColor.BLUE.func_176767_b();
                }
            }
            return false;
        }
    }

    private class PlasticFluidTank
    extends ISmartFluidSync.SmartSyncTank {
        PlasticFluidTank(int capacity) {
            super(TileEntityPlasticMixer.this, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return PlasticMixerRegistry.INSTANCE.isValidFluid(fluid);
        }
    }
}

