/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.crafting.ShapedOreOutputRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static final ResourceLocation EMPTY_GROUP = new ResourceLocation("", "");

    public static void addShapedRecipe(ItemStack output, Object ... input) {
        RecipeHelper.addShapedRecipe(EMPTY_GROUP, output, input);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        RecipeHelper.addShapelessRecipe(EMPTY_GROUP, output, input);
    }

    public static void addShapedOreOutputRecipe(String ore, int amount, Object ... input) {
        RecipeHelper.addShapedOreOutputRecipe(EMPTY_GROUP, ore, amount, input);
    }

    public static void addShapedRecipe(ResourceLocation group, ItemStack output, Object ... input) {
        for (Object obj : input) {
            if (obj != null) continue;
            return;
        }
        ForgeRegistries.RECIPES.register(new ShapedOreRecipe(group, output, input).setRegistryName(RecipeHelper.getRecipeLocation(output)));
    }

    public static void addShapelessRecipe(ResourceLocation group, ItemStack output, Object ... input) {
        for (Object obj : input) {
            if (obj != null) continue;
            return;
        }
        ForgeRegistries.RECIPES.register(new ShapelessOreRecipe(group, output, input).setRegistryName(RecipeHelper.getRecipeLocation(output)));
    }

    public static void addShapedOreOutputRecipe(ResourceLocation group, String ore, int amount, Object ... input) {
        for (Object obj : input) {
            if (obj != null) continue;
            return;
        }
        ForgeRegistries.RECIPES.register(new ShapedOreOutputRecipe(group, ore, amount, input).setRegistryName(RecipeHelper.getRecipeLocation(ore)));
    }

    public static ResourceLocation getRecipeLocation(ItemStack output) {
        ResourceLocation baseLoc;
        String namespace = Loader.instance().activeModContainer().getModId();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(namespace, output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(namespace, baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static ResourceLocation getRecipeLocation(String name) {
        ResourceLocation baseLoc;
        String namespace = Loader.instance().activeModContainer().getModId();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(namespace, name);
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(namespace, baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }
}

