/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockDisguisable;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.entity.camera.EntitySecurityCamera;
import net.geforcemods.securitycraft.items.ItemSonicSecuritySystem;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.TileEntityTracker;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockChangeDetector;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="securitycraft")
public class SCClientEventHandler {
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");

    @SubscribeEvent
    public static void onRenderLevelStage(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        WorldClient level = mc.field_71441_e;
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        for (BlockPos bcdPos : TileEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedTileEntities((World)level)) {
            TileEntityBlockChangeDetector bcd;
            TileEntity be = level.func_175625_s(bcdPos);
            if (!(be instanceof TileEntityBlockChangeDetector) || !(bcd = (TileEntityBlockChangeDetector)be).isShowingHighlights() || !bcd.getOwner().isOwner((EntityPlayer)mc.field_71439_g)) continue;
            for (TileEntityBlockChangeDetector.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                BlockPos pos = changeEntry.pos;
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - x), (double)((double)pos.func_177956_o() - y), (double)((double)pos.func_177952_p() - z));
                ClientUtils.renderBoxInLevel(0, 1, 0, 1, 1, bcd.getColor());
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
            EntitySecurityCamera camera = (EntitySecurityCamera)Minecraft.func_71410_x().func_175606_aa();
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.func_71410_x().field_71441_e.func_184156_a(player.func_180425_c(), SCSounds.CAMERASNAP.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(MouseEvent event) {
        if (event.getButton() == 0 && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Pre event) {
        if ((event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE || event.getType() == RenderGameOverlayEvent.ElementType.JUMPBAR || event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) && ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            if (ClientProxy.isPlayerMountedOnCamera()) {
                GuiUtils.drawCameraOverlay(Minecraft.func_71410_x(), (Gui)Minecraft.func_71410_x().field_71456_v, event.getResolution(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().func_175606_aa().func_180425_c().func_177977_b());
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                EntityPlayerSP player = mc.field_71439_g;
                World world = player.func_130014_f_();
                float reachDistance = mc.field_71442_b.func_78757_d();
                for (EnumHand hand : EnumHand.values()) {
                    Object[] coords;
                    RayTraceResult mop;
                    ItemStack stack = player.func_184586_b(hand);
                    int uCoord = 0;
                    if (stack.func_77973_b() == SCContent.cameraMonitor) {
                        double eyeHeight = player.func_70047_e();
                        Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * (double)reachDistance, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * (double)reachDistance, player.field_70161_v + player.func_70040_Z().field_72449_c * (double)reachDistance);
                        mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_178782_a()) instanceof TileEntitySecurityCamera) {
                            uCoord = 110;
                            NBTTagCompound cameras = stack.func_77978_p();
                            if (cameras != null) {
                                for (int i = 1; i < 31; ++i) {
                                    if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_178782_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_178782_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_178782_a().func_177952_p()) continue;
                                    uCoord = 88;
                                    break;
                                }
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.remoteAccessMine) {
                        double eyeHeight = player.func_70047_e();
                        Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * (double)reachDistance, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * (double)reachDistance, player.field_70161_v + player.func_70040_Z().field_72449_c * (double)reachDistance);
                        mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_178782_a()).func_177230_c() instanceof IExplosive) {
                            uCoord = 110;
                            NBTTagCompound mines = stack.func_77978_p();
                            if (mines != null) {
                                for (int i = 1; i <= 6; ++i) {
                                    if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = (Object[])mines.func_74759_k("mine" + i))[0] != mop.func_178782_a().func_177958_n() || coords[1] != mop.func_178782_a().func_177956_o() || coords[2] != mop.func_178782_a().func_177952_p()) continue;
                                    uCoord = 88;
                                    break;
                                }
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.remoteAccessSentry) {
                        Entity hitEntity = Minecraft.func_71410_x().field_147125_j;
                        if (hitEntity instanceof EntitySentry) {
                            uCoord = 110;
                            NBTTagCompound sentries = stack.func_77978_p();
                            if (sentries != null) {
                                for (int i = 1; i <= 12; ++i) {
                                    int[] coords2;
                                    if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords2 = sentries.func_74759_k("sentry" + i))[0] != hitEntity.func_180425_c().func_177958_n() || coords2[1] != hitEntity.func_180425_c().func_177956_o() || coords2[2] != hitEntity.func_180425_c().func_177952_p()) continue;
                                    uCoord = 88;
                                    break;
                                }
                            }
                        }
                    } else if (stack.func_77973_b() == SCContent.sonicSecuritySystemItem) {
                        TileEntity te;
                        double eyeHeight = player.func_70047_e();
                        Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * (double)reachDistance, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * (double)reachDistance, player.field_70161_v + player.func_70040_Z().field_72449_c * (double)reachDistance);
                        mop = world.func_72933_a(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec);
                        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK && (te = world.func_175625_s(mop.func_178782_a())) instanceof ILockable) {
                            Block block;
                            BlockPos pos = mop.func_178782_a();
                            if (!(te instanceof IOwnable && ((IOwnable)te).getOwner().isOwner((EntityPlayer)player) || !((block = te.func_145838_q()) instanceof BlockDisguisable) || ((BlockDisguisable)block).getDisguisedBlockState((IBlockAccess)world, pos) == null)) {
                                return;
                            }
                            uCoord = 110;
                            if (!stack.func_77942_o()) {
                                stack.func_77982_d(new NBTTagCompound());
                            }
                            if (ItemSonicSecuritySystem.isAdded(stack.func_77978_p(), pos)) {
                                uCoord = 88;
                            }
                        }
                    }
                    if (uCoord == 0) continue;
                    GlStateManager.func_179141_d();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(BEACON_GUI);
                    SCClientEventHandler.drawNonStandardTexturedRect(event.getResolution().func_78326_a() / 2 - 90 + (hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c * 20 : (mc.field_71474_y.field_186715_A == EnumHandSide.LEFT ? 189 : -29)), event.getResolution().func_78328_b() - 22, uCoord, 219, 21, 22, 256, 256);
                    GlStateManager.func_179118_c();
                }
            }
        }
    }

    private static void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), z).func_187315_a((double)u * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)(u + width) * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, z).func_187315_a((double)(u + width) * widthFactor, (double)v * heightFactor).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, z).func_187315_a((double)u * widthFactor, (double)v * heightFactor).func_181675_d();
        tessellator.func_78381_a();
    }
}

